/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.util;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PoiSheetUtility {
    public static void deleteColumn(Sheet sheet, int columnToDelete) {
        int maxColumn = 0;
        for (int r = 0; r < sheet.getLastRowNum() + 1; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            int lastColumn = row.getLastCellNum();
            if (lastColumn > maxColumn) {
                maxColumn = lastColumn;
            }
            if (lastColumn < columnToDelete) continue;
            for (int x = columnToDelete + 1; x < lastColumn + 1; ++x) {
                Cell nextCell;
                Cell oldCell = row.getCell(x - 1);
                if (oldCell != null) {
                    row.removeCell(oldCell);
                }
                if ((nextCell = row.getCell(x)) == null) continue;
                Cell newCell = row.createCell(x - 1, nextCell.getCellType());
                PoiSheetUtility.cloneCell(newCell, nextCell);
            }
        }
        for (int c = 0; c < maxColumn; ++c) {
            sheet.setColumnWidth(c, sheet.getColumnWidth(c + 1));
        }
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        if (CellType.BOOLEAN == cNew.getCellType()) {
            cNew.setCellValue(cOld.getBooleanCellValue());
        } else if (CellType.NUMERIC == cNew.getCellType()) {
            cNew.setCellValue(cOld.getNumericCellValue());
        } else if (CellType.STRING == cNew.getCellType()) {
            cNew.setCellValue(cOld.getStringCellValue());
        } else if (CellType.ERROR == cNew.getCellType()) {
            cNew.setCellValue((double)cOld.getErrorCellValue());
        } else if (CellType.FORMULA == cNew.getCellType()) {
            cNew.setCellFormula(cOld.getCellFormula());
        }
    }
}

