/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.barcode.entity.ElsBarcodeTemplateHead;
import com.els.modules.barcode.entity.ElsBarcodeTemplateItem;
import com.els.modules.barcode.enumerate.ElsBarcodeFiledType;
import com.els.modules.barcode.service.ElsBarcodeTemplateHeadService;
import com.els.modules.barcode.service.ElsBarcodeTemplateItemService;
import com.els.modules.barcode.vo.ElsBarcodeTemplateHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/barcode/elsBarcodeTemplateHead"})
@Api(tags={"\u6761\u7801\u6a21\u677f\u5934\u8868"})
public class ElsBarcodeTemplateHeadController
extends BaseController<ElsBarcodeTemplateHead, ElsBarcodeTemplateHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsBarcodeTemplateHeadController.class);
    @Autowired
    private ElsBarcodeTemplateHeadService elsBarcodeTemplateHeadService;
    @Autowired
    private ElsBarcodeTemplateItemService elsBarcodeTemplateItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsBarcodeTemplateHead elsBarcodeTemplateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeTemplateHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeTemplateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsBarcodeTemplateHeadVO elsBarcodeTemplateHeadPage) {
        ElsBarcodeTemplateHead elsBarcodeTemplateHead = new ElsBarcodeTemplateHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeTemplateHeadPage), (Object)((Object)elsBarcodeTemplateHead));
        this.elsBarcodeTemplateHeadService.saveMain(elsBarcodeTemplateHead, elsBarcodeTemplateHeadPage.getElsBarcodeTemplateItemList());
        return Result.ok((Object)((Object)elsBarcodeTemplateHead));
    }

    @AutoLog(busModule="\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsBarcodeTemplateHeadVO elsBarcodeTemplateHeadPage) {
        ElsBarcodeTemplateHead elsBarcodeTemplateHead = new ElsBarcodeTemplateHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeTemplateHeadPage), (Object)((Object)elsBarcodeTemplateHead));
        this.elsBarcodeTemplateHeadService.updateMain(elsBarcodeTemplateHead, elsBarcodeTemplateHeadPage.getElsBarcodeTemplateItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsBarcodeTemplateHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.elsBarcodeTemplateHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsBarcodeTemplateHead elsBarcodeTemplateHead = (ElsBarcodeTemplateHead)((Object)this.elsBarcodeTemplateHeadService.getById((Serializable)((Object)id)));
        ElsBarcodeTemplateHeadVO elsBarcodeTemplateHeadVO = new ElsBarcodeTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeTemplateHead), (Object)((Object)elsBarcodeTemplateHeadVO));
        List<ElsBarcodeTemplateItem> elsBarcodeTemplateItemList = this.elsBarcodeTemplateItemService.selectByMainId(id);
        elsBarcodeTemplateHeadVO.setElsBarcodeTemplateItemList(elsBarcodeTemplateItemList);
        return Result.ok((Object)((Object)elsBarcodeTemplateHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u6761\u7801\u6a21\u677f\u5934\u8868id\u67e5\u8be2\u6761\u7801\u6a21\u677f\u884c\u8868", notes="\u901a\u8fc7\u6761\u7801\u6a21\u677f\u5934\u8868id\u67e5\u8be2\u6761\u7801\u6a21\u677f\u884c\u8868")
    @GetMapping(value={"/queryElsBarcodeTemplateItemByMainId"})
    public Result<?> queryElsBarcodeTemplateItemListByMainId(@RequestParam(name="id") String id) {
        List<ElsBarcodeTemplateItem> elsBarcodeTemplateItemList = this.elsBarcodeTemplateItemService.selectByMainId(id);
        return Result.ok(elsBarcodeTemplateItemList);
    }

    @AutoLog(busModule="\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6a21\u677f\u89e3\u6790")
    @ApiOperation(value="\u6a21\u677f\u89e3\u6790", notes="\u6a21\u677f\u89e3\u6790")
    @GetMapping(value={"/templateResolve"})
    public Result<?> templateResolve(@RequestParam(name="id") String id) {
        ElsBarcodeTemplateHead elsBarcodeTemplateHead = (ElsBarcodeTemplateHead)((Object)this.elsBarcodeTemplateHeadService.getById((Serializable)((Object)id)));
        List<ElsBarcodeTemplateItem> elsBarcodeTemplateItemList = this.elsBarcodeTemplateItemService.selectByMainId(id);
        String[] arr = elsBarcodeTemplateItemList.stream().filter(item -> ElsBarcodeFiledType.CHANGE.value().equals(item.getFiledType())).findFirst().get().getDatasource().split(",");
        StringBuffer buffer = new StringBuffer("LODOP.PRINT_INIT(\" " + elsBarcodeTemplateHead.getTemplateName() + " \");");
        for (ElsBarcodeTemplateItem item2 : elsBarcodeTemplateItemList) {
            if (ElsBarcodeFiledType.CHANGE.value().equals(item2.getFiledType())) {
                // empty if block
            }
            buffer.append(item2.getDesignContent().substring(item2.getDesignContent().lastIndexOf(",")));
        }
        return Result.ok(null);
    }

    @AutoLog(busModule="\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6a21\u677f\u9884\u89c8")
    @ApiOperation(value="\u6a21\u677f\u9884\u89c8", notes="\u6a21\u677f\u9884\u89c8")
    @PostMapping(value={"/templatePreview"})
    public Result<?> templatePreview(@RequestBody Map<String, String> map, HttpServletRequest httpServletRequest) {
        String[] itemArr;
        String designContent = map.get("designContent");
        ArrayList<ElsBarcodeTemplateItem> itemList = new ArrayList<ElsBarcodeTemplateItem>();
        for (String item : itemArr = designContent.replaceAll("\r", "").replaceAll("\n", "").split(";")) {
            String head = item.substring(item.indexOf("."), item.indexOf("("));
            String designType = head.substring(head.lastIndexOf("_") + 1);
            if ("INIT".equals(designType)) continue;
            String barcodeType = null;
            if (head.contains("BARCODE")) {
                barcodeType = item.substring(item.indexOf("(")).split(",")[4].replaceAll("\"", "");
            }
            ElsBarcodeTemplateItem templateItem = new ElsBarcodeTemplateItem();
            templateItem.setDesignContent(item);
            templateItem.setBarcodeType(barcodeType);
            templateItem.setDesignType(designType);
            itemList.add(templateItem);
        }
        return Result.ok(itemList);
    }
}

