/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FieldDescribe;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.enumerate.ElsBarcodeBusinessEnum;
import com.els.modules.barcode.api.ElsTableRpcService;
import com.els.modules.barcode.entity.ElsBarcodeAttribute;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.rpc.service.ElsTableSelectService;
import com.els.modules.barcode.service.ElsBarcodeAttributeService;
import com.els.modules.barcode.vo.ElsBarcodeAttributeVO;
import com.els.modules.barcode.vo.ElsBarcodeFiledVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6761\u7801\u5c5e\u6027\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/base/barcode/elsBarcodeAttribute"})
public class ElsBarcodeAttributeController
extends BaseController<ElsBarcodeAttribute, ElsBarcodeAttributeService> {
    @Autowired
    private ElsBarcodeAttributeService elsBarcodeAttributeService;
    @Autowired
    private ElsTableSelectService elsTableSelectService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsBarcodeAttribute elsBarcodeAttribute, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        HashMap newParameterMap = new HashMap();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            newParameterMap.put(entry.getKey(), entry.getValue());
        }
        String[] column = new String[((String[])newParameterMap.get("column")).length + 1];
        column[0] = "sort_no";
        for (int i = 0; i < ((String[])newParameterMap.get("column")).length; ++i) {
            column[i + 1] = ((String[])newParameterMap.get("column"))[i];
        }
        newParameterMap.put("column", column);
        String[] order = new String[((String[])newParameterMap.get("order")).length + 1];
        order[0] = "asc";
        for (int i = 0; i < ((String[])newParameterMap.get("order")).length; ++i) {
            order[i + 1] = ((String[])newParameterMap.get("order"))[i];
        }
        newParameterMap.put("order", order);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeAttribute), newParameterMap);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeAttributeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)")
    @GetMapping(value={"/enableList"})
    public Result<?> queryPageEnableList(ElsBarcodeAttribute elsBarcodeAttribute, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeAttribute), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"attribute_status", (Object)SrmEnabledStatusEnum.ENABLED);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeAttributeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u72b6\u6001\u53d8\u66f4")
    @ApiOperation(value="\u72b6\u6001\u53d8\u66f4", notes="\u72b6\u6001\u53d8\u66f4")
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody ElsBarcodeAttributeVO elsBarcodeAttributeVO) {
        if ("1".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setAttributeStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        } else if ("2".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setAttributeStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        }
        ElsBarcodeAttribute elsBarcodeAttribute = new ElsBarcodeAttribute();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeAttributeVO), (Object)((Object)elsBarcodeAttribute));
        this.elsBarcodeAttributeService.updateById((Object)elsBarcodeAttribute);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsBarcodeAttribute elsBarcodeAttribute) {
        this.elsBarcodeAttributeService.saveElsBarcodeAttribute(elsBarcodeAttribute);
        return Result.ok((Object)((Object)elsBarcodeAttribute));
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsBarcodeAttribute elsBarcodeAttribute) {
        this.elsBarcodeAttributeService.updateElsBarcodeAttribute(elsBarcodeAttribute);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsBarcodeAttributeService.delElsBarcodeAttribute(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsBarcodeAttributeService.delBatchElsBarcodeAttribute(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsBarcodeAttribute elsBarcodeAttribute = (ElsBarcodeAttribute)((Object)this.elsBarcodeAttributeService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)elsBarcodeAttribute));
    }

    @ApiOperation(value="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2", notes="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageFieldList"})
    public Result<?> queryPageFieldList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        try {
            Field[] fields;
            String keyWord = req.getParameter("keyWord");
            ArrayList<ElsBarcodeFiledVO> filedList = new ArrayList<ElsBarcodeFiledVO>();
            String businessType = req.getParameter("businessType");
            String classPath = ElsBarcodeBusinessEnum.getPathByValue((String)businessType);
            if (StringUtils.isBlank((CharSequence)classPath)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_APEStFmhxuERdW_59629763", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            Class<?> clazz = Class.forName(classPath);
            for (Field filed : fields = clazz.getDeclaredFields()) {
                boolean annotation;
                if (!filed.isAccessible()) {
                    filed.setAccessible(true);
                }
                if (!(annotation = filed.isAnnotationPresent(FieldDescribe.class))) continue;
                FieldDescribe methodAnno = filed.getAnnotation(FieldDescribe.class);
                ElsBarcodeFiledVO obj = new ElsBarcodeFiledVO();
                obj.setFiledName(methodAnno.name());
                obj.setFiled(filed.getName());
                obj.setFiledType(filed.getType().getName());
                if (StringUtils.isNotBlank((CharSequence)keyWord) && !methodAnno.name().contains(keyWord) && !filed.getName().contains(keyWord)) continue;
                filedList.add(obj);
            }
            Page filePage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            filePage.setRecords(filedList);
            return Result.ok((Object)filePage);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return Result.ok(null);
        }
    }

    @ApiOperation(value="\u8868\u5b57\u6bb5\u503c\u5217\u8868\u67e5\u8be2", notes="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageFieldValueList"})
    public Result<?> queryPageFieldValueList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        try {
            String keyWord = req.getParameter("keyWord");
            ArrayList filedList = new ArrayList();
            String businessType = req.getParameter("businessType");
            String businessField = req.getParameter("businessField");
            if (StringUtils.isBlank((CharSequence)businessType)) {
                return Result.error((String)I18nUtil.translate((String)"", (String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StringUtils.isBlank((CharSequence)businessField)) {
                return Result.error((String)I18nUtil.translate((String)"", (String)"\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            String serviceName = ElsBarcodeBusinessEnum.getPathByService((String)businessType);
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                return Result.error((String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            ElsTableRpcService elsTableRpcService = this.elsTableSelectService.getTableService(serviceName);
            IPage list = elsTableRpcService.selectListByBusinessType(businessType, businessField, pageNo, pageSize, req.getParameterMap());
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.ok(null);
        }
    }
}

