/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tactics.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.excel.poi.excel.ExcelImportUtil;
import com.els.common.excel.poi.excel.entity.ExportParams;
import com.els.common.excel.poi.excel.entity.ImportParams;
import com.els.common.excel.poi.excel.view.ELSEntityExcelView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.tactics.entity.ElsTacticsHead;
import com.els.modules.tactics.entity.ElsTacticsItem;
import com.els.modules.tactics.service.ElsTacticsHeadService;
import com.els.modules.tactics.service.ElsTacticsItemService;
import com.els.modules.tactics.vo.ElsTacticsHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/tactics/elsTacticsHead"})
@Api(tags={"\u7b56\u7565\u5934"})
public class ElsTacticsHeadController
extends BaseController<ElsTacticsHead, ElsTacticsHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsTacticsHeadController.class);
    @Autowired
    private ElsTacticsHeadService elsTacticsHeadService;
    @Autowired
    private ElsTacticsItemService elsTacticsItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsTacticsHead elsTacticsHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTacticsHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTacticsHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsTacticsHeadVO elsTacticsHeadPage) {
        ElsTacticsHead elsTacticsHead = new ElsTacticsHead();
        BeanUtils.copyProperties((Object)((Object)elsTacticsHeadPage), (Object)((Object)elsTacticsHead));
        this.elsTacticsHeadService.saveMain(elsTacticsHead, elsTacticsHeadPage.getElsTacticsItemList());
        return Result.ok((Object)((Object)elsTacticsHead));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsTacticsHeadVO elsTacticsHeadPage) {
        ElsTacticsHead elsTacticsHead = new ElsTacticsHead();
        BeanUtils.copyProperties((Object)((Object)elsTacticsHeadPage), (Object)((Object)elsTacticsHead));
        this.elsTacticsHeadService.updateMain(elsTacticsHead, elsTacticsHeadPage.getElsTacticsItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsTacticsHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.elsTacticsHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsTacticsHead elsTacticsHead = (ElsTacticsHead)((Object)this.elsTacticsHeadService.getById((Serializable)((Object)id)));
        ElsTacticsHeadVO elsTacticsHeadVO = new ElsTacticsHeadVO();
        BeanUtils.copyProperties((Object)((Object)elsTacticsHead), (Object)((Object)elsTacticsHeadVO));
        List<ElsTacticsItem> elsTacticsItemList = this.elsTacticsItemService.selectByMainId(id);
        elsTacticsHeadVO.setElsTacticsItemList(elsTacticsItemList);
        return Result.ok((Object)((Object)elsTacticsHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u7b56\u7565\u5934id\u67e5\u8be2\u7b56\u7565\u884c", notes="\u901a\u8fc7\u7b56\u7565\u5934id\u67e5\u8be2\u7b56\u7565\u884c")
    @GetMapping(value={"/queryElsTacticsItemByMainId"})
    public Result<?> queryElsTacticsItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<ElsTacticsItem> elsTacticsItemList = this.elsTacticsItemService.selectByMainId(id);
        return Result.ok(elsTacticsItemList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsTacticsHead elsTacticsHead) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTacticsHead), (Map)request.getParameterMap());
        LoginUser sysUser = SysUtil.getLoginUser();
        ArrayList<ElsTacticsHeadVO> pageList = new ArrayList<ElsTacticsHeadVO>();
        List elsTacticsHeadList = this.elsTacticsHeadService.list((Wrapper)queryWrapper);
        for (ElsTacticsHead temp : elsTacticsHeadList) {
            ElsTacticsHeadVO vo = new ElsTacticsHeadVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<ElsTacticsItem> elsTacticsItemList = this.elsTacticsItemService.selectByMainId(temp.getId());
            vo.setElsTacticsItemList(elsTacticsItemList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u7b56\u7565\u5934");
        mv.addObject("entity", ElsTacticsHeadVO.class);
        mv.addObject("params", (Object)new ExportParams("\u7b56\u7565\u5934\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u7b56\u7565\u5934", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), ElsTacticsHeadVO.class, (ImportParams)params);
                for (ElsTacticsHeadVO page : list) {
                    ElsTacticsHead po = new ElsTacticsHead();
                    BeanUtils.copyProperties((Object)((Object)page), (Object)((Object)po));
                    this.elsTacticsHeadService.saveMain(po, page.getElsTacticsItemList());
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + list.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

