/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.BarcodeSupplierList;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.enumerate.BarcodeResolveTypeEnum;
import com.els.modules.barcode.enumerate.PurchaseBarcodeInfoStatusEnum;
import com.els.modules.barcode.mapper.BarcodeSupplierListMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeInfoDetailMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeInfoHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeInfoItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodeInfoHeadService;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodeInfoHeadService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodeInfoHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodeInfoHeadMapper, PurchaseBarcodeInfoHead>
implements PurchaseBarcodeInfoHeadService {
    @Autowired
    private PurchaseBarcodeInfoHeadMapper purchaseBarcodeInfoHeadMapper;
    @Autowired
    private PurchaseBarcodeInfoItemMapper purchaseBarcodeInfoItemMapper;
    @Autowired
    private PurchaseBarcodeInfoDetailMapper purchaseBarcodeInfoDetailMapper;
    @Autowired
    private BarcodeSupplierListMapper barcodeSupplierListMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private SaleBarcodeInfoHeadService saleBarcodeInfoHeadService;
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;
    @Autowired
    private ElsBarcodeRuleHeadMapper elsBarcodeRuleHeadMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        purchaseBarcodeInfoHead.setInfoNumber(this.codeGeneratorService.getNextCode("srmBarcodeInfoNumber", (Object)purchaseBarcodeInfoHead));
        purchaseBarcodeInfoHead.setInfoStatus(PurchaseBarcodeInfoStatusEnum.NEW.getValue());
        this.purchaseBarcodeInfoHeadMapper.insert((Object)purchaseBarcodeInfoHead);
        this.insertData(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        this.purchaseBarcodeInfoHeadMapper.updateById((Object)purchaseBarcodeInfoHead);
        this.purchaseBarcodeInfoItemMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.purchaseBarcodeInfoDetailMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.barcodeSupplierListMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.insertData(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        if ("0".equals(purchaseBarcodeInfoHead.getPublishAudit())) {
            purchaseBarcodeInfoHead.setInfoStatus(PurchaseBarcodeInfoStatusEnum.PUBLISH.getValue());
            purchaseBarcodeInfoHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseBarcodeInfoHeadMapper.updateById((Object)purchaseBarcodeInfoHead);
        this.purchaseBarcodeInfoItemMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.purchaseBarcodeInfoDetailMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.barcodeSupplierListMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.insertData(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList);
        if ("0".equals(purchaseBarcodeInfoHead.getPublishAudit())) {
            ElsBarcodeRuleHead ruleHead = (ElsBarcodeRuleHead)((Object)this.elsBarcodeRuleHeadMapper.selectById((Serializable)((Object)purchaseBarcodeInfoHead.getRuleId())));
            if (BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType())) {
                this.purchaseBarcodePoolHeadService.addByBarcodeInfo(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList);
            }
            this.saleBarcodeInfoHeadService.addByPurchase(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList, BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType()));
        }
    }

    private void insertData(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        if (purchaseBarcodeInfoItemList != null && purchaseBarcodeInfoItemList.size() > 0) {
            for (PurchaseBarcodeInfoItem purchaseBarcodeInfoItem : purchaseBarcodeInfoItemList) {
                purchaseBarcodeInfoItem.setHeadId(purchaseBarcodeInfoHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseBarcodeInfoItem, (BaseEntity)purchaseBarcodeInfoHead);
            }
            this.purchaseBarcodeInfoItemMapper.insertBatchSomeColumn(purchaseBarcodeInfoItemList);
        }
        if (sysBarcodeList != null && sysBarcodeList.size() > 0) {
            ArrayList<PurchaseBarcodeInfoDetail> resultDetailList = new ArrayList<PurchaseBarcodeInfoDetail>();
            for (PurchaseBarcodeInfoDetail entity : sysBarcodeList) {
                entity.setHeadId(purchaseBarcodeInfoHead.getId());
                entity.setBarcodeType(1);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBarcodeInfoHead);
            }
            resultDetailList.addAll(sysBarcodeList);
            if (customBarcodeList != null && customBarcodeList.size() > 0) {
                for (PurchaseBarcodeInfoDetail entity : customBarcodeList) {
                    entity.setHeadId(purchaseBarcodeInfoHead.getId());
                    entity.setBarcodeType(2);
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBarcodeInfoHead);
                }
                resultDetailList.addAll(customBarcodeList);
            }
            this.purchaseBarcodeInfoDetailMapper.insertBatchSomeColumn(resultDetailList);
        }
        if (barcodeSupplierListList != null && barcodeSupplierListList.size() > 0) {
            for (BarcodeSupplierList barcodeSupplierList : barcodeSupplierListList) {
                barcodeSupplierList.setHeadId(purchaseBarcodeInfoHead.getId());
                SysUtil.setSysParam((BaseEntity)barcodeSupplierList, (BaseEntity)purchaseBarcodeInfoHead);
            }
            this.barcodeSupplierListMapper.insertBatchSomeColumn(barcodeSupplierListList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBarcodeInfoItemMapper.deleteByMainId(id);
        this.purchaseBarcodeInfoHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodeInfoItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodeInfoHeadMapper.deleteById(serializable);
        }
    }
}

