/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelHead;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelItem;
import com.els.modules.barcode.entity.SaleBarcodeLevelHead;
import com.els.modules.barcode.entity.SaleBarcodeLevelItem;
import com.els.modules.barcode.enumerate.BarcodeLevelStatusEnum;
import com.els.modules.barcode.mapper.PurchaseBarcodeLevelHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeLevelItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodeLevelHeadService;
import com.els.modules.barcode.service.SaleBarcodeLevelHeadService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodeLevelHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodeLevelHeadMapper, PurchaseBarcodeLevelHead>
implements PurchaseBarcodeLevelHeadService {
    @Autowired
    private PurchaseBarcodeLevelHeadMapper purchaseBarcodeLevelHeadMapper;
    @Autowired
    private PurchaseBarcodeLevelItemMapper purchaseBarcodeLevelItemMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    @Lazy
    private SaleBarcodeLevelHeadService saleBarcodeLevelHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        purchaseBarcodeLevelHead.setLevelNumber(this.codeGeneratorService.getNextCode("srmBarcodeInfoNumber", (Object)purchaseBarcodeLevelHead));
        purchaseBarcodeLevelHead.setLevelStatus(BarcodeLevelStatusEnum.NEW.getValue());
        ElsEnterpriseInfoDTO enterpriseInfo = this.invokeAccountRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchaseBarcodeLevelHead.setPurchaseName(enterpriseInfo.getName());
        }
        this.purchaseBarcodeLevelHeadMapper.insert((Object)purchaseBarcodeLevelHead);
        this.insertData(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        this.purchaseBarcodeLevelHeadMapper.updateById((Object)purchaseBarcodeLevelHead);
        this.purchaseBarcodeLevelItemMapper.deleteByMainId(purchaseBarcodeLevelHead.getId());
        this.insertData(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        purchaseBarcodeLevelHead.setLevelStatus(BarcodeLevelStatusEnum.FINAL.getValue());
        this.purchaseBarcodeLevelHeadMapper.updateById((Object)purchaseBarcodeLevelHead);
        this.purchaseBarcodeLevelItemMapper.deleteByMainId(purchaseBarcodeLevelHead.getId());
        this.insertData(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
        if (StringUtils.isNotBlank((CharSequence)purchaseBarcodeLevelHead.getToElsAccount())) {
            Integer n = this.saleBarcodeLevelHeadService.addByPurchase(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
        }
    }

    private void insertData(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        if (purchaseBarcodeLevelItemList != null && !purchaseBarcodeLevelItemList.isEmpty()) {
            for (PurchaseBarcodeLevelItem entity : purchaseBarcodeLevelItemList) {
                entity.setHeadId(purchaseBarcodeLevelHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBarcodeLevelHead);
            }
            this.purchaseBarcodeLevelItemMapper.insertBatchSomeColumn(purchaseBarcodeLevelItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBarcodeLevelItemMapper.deleteByMainId(id);
        this.purchaseBarcodeLevelHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodeLevelItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodeLevelHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public Integer addBySale(SaleBarcodeLevelHead saleBarcodeLevelHead, List<SaleBarcodeLevelItem> saleBarcodeLevelItemList) {
        String saleEls = saleBarcodeLevelHead.getElsAccount();
        PurchaseBarcodeLevelHead purchaseBarcodeLevelHead = new PurchaseBarcodeLevelHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodeLevelHead), (Object)((Object)purchaseBarcodeLevelHead));
        purchaseBarcodeLevelHead.setId(null);
        purchaseBarcodeLevelHead.setElsAccount(saleBarcodeLevelHead.getToElsAccount());
        purchaseBarcodeLevelHead.setToElsAccount(saleEls);
        this.purchaseBarcodeLevelHeadMapper.insert((Object)purchaseBarcodeLevelHead);
        ArrayList<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList = new ArrayList<PurchaseBarcodeLevelItem>();
        for (SaleBarcodeLevelItem item : saleBarcodeLevelItemList) {
            PurchaseBarcodeLevelItem purchaseBarcodeLevelItem = new PurchaseBarcodeLevelItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)purchaseBarcodeLevelItem));
            purchaseBarcodeLevelItem.setElsAccount(purchaseBarcodeLevelHead.getElsAccount());
            purchaseBarcodeLevelItem.setHeadId(purchaseBarcodeLevelHead.getId());
            purchaseBarcodeLevelItem.setId(null);
            purchaseBarcodeLevelItemList.add(purchaseBarcodeLevelItem);
        }
        return this.purchaseBarcodeLevelItemMapper.insertBatchSomeColumn(purchaseBarcodeLevelItemList);
    }
}

