/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.modules.barcode.encryption.base.IEncryption;
import com.els.modules.barcode.entity.PurchaseBarcodePoolRecord;
import com.els.modules.barcode.enumerate.EncryptionEnum;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.mapper.ElsBarCodeShortCodeMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolRecordMapper;
import com.els.modules.barcode.service.PurchaseExplainService;
import com.els.modules.barcode.service.impl.base.BaseExplainService;
import com.els.modules.barcode.utils.BarCodeSubUtil;
import com.els.modules.barcode.vo.BarCodeEncryptionVO;
import com.els.modules.barcode.vo.BarCodeExplainItemVO;
import com.els.modules.barcode.vo.BarCodeExplainReqVO;
import com.els.modules.barcode.vo.BarCodeExplainRespVO;
import com.els.modules.barcode.vo.BarCodePoolItemVO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseExplainServiceImpl
extends BaseExplainService
implements PurchaseExplainService {
    @Resource
    private PurchaseBarcodePoolHeadMapper poolHeadMapper;
    @Resource
    private PurchaseBarcodePoolRecordMapper poolRecordMapper;

    @Override
    @Resource
    public void setRuleHeadMapper(ElsBarcodeRuleHeadMapper ruleHeadMapper) {
        super.setRuleHeadMapper(ruleHeadMapper);
    }

    @Override
    @Resource
    public void setShortCodeMapper(ElsBarCodeShortCodeMapper shortCodeMapper) {
        super.setShortCodeMapper(shortCodeMapper);
    }

    @Override
    protected List<BarCodeExplainItemVO> barCodeLibrary(String barCodeContent) {
        List<BarCodePoolItemVO> itemVOS = this.poolHeadMapper.getPoolItemByBarCode(barCodeContent);
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(itemVOS), (Enum)I18nBarCodeEnum.LIBRARY_NOT_FOUND);
        List<BarCodeExplainItemVO> explainItemVOS = itemVOS.stream().map(itemVO -> {
            BarCodeExplainItemVO explainItemVO = new BarCodeExplainItemVO();
            explainItemVO.setAttrType(itemVO.getBusinessType()).setAttrName(itemVO.getBusinessFieldName()).setOriginalValue(itemVO.getAttribute());
            if ("1".equals(itemVO.getUsedCode())) {
                String shortCodeValue = this.getShortCodeValue(itemVO.getAttribute(), itemVO.getCodeType());
                explainItemVO.setShortCode(shortCodeValue);
            }
            return explainItemVO;
        }).collect(Collectors.toList());
        return explainItemVOS;
    }

    @Override
    protected BarCodeExplainRespVO explainByLibrary(String barCodeContent, int saveOperaRecord) {
        List<BarCodeExplainItemVO> itemVOS = this.barCodeLibrary(barCodeContent);
        if (1 == saveOperaRecord) {
            PurchaseBarcodePoolRecord poolRecord = new PurchaseBarcodePoolRecord();
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            poolRecord.setHeadId(this.poolHeadMapper.getIdByBarCode(barCodeContent)).setBusinessType("\u626b\u63cf\u6761\u7801").setOperation("\u626b\u63cf").setOperator(sysUser.getSubAccount()).setOperateTime(new Date());
            this.poolRecordMapper.insert((Object)poolRecord);
        }
        return new BarCodeExplainRespVO(this.originalBarcode(barCodeContent), itemVOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BarCodeExplainRespVO barCodeExplain(BarCodeExplainReqVO barCodeExplainReqVO) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)barCodeExplainReqVO.getBarCodeContent()), (Enum)I18nBarCodeEnum.BAR_CODE_IS_NULL);
        if (0 == barCodeExplainReqVO.getExplainStrategy()) {
            return new BarCodeExplainRespVO(this.originalBarcode(barCodeExplainReqVO.getBarCodeContent()));
        }
        if (2 == barCodeExplainReqVO.getExplainStrategy()) {
            return this.explainByRule(barCodeExplainReqVO.getBarCodeContent());
        }
        return this.explainByLibrary(barCodeExplainReqVO.getBarCodeContent(), barCodeExplainReqVO.getSaveOperaRecord());
    }

    @Override
    public List<BarCodeEncryptionVO> barCodeEncrypt(List<String> barCodes) {
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(barCodes), (Enum)I18nBarCodeEnum.ENCRYPTION_DATA_NULL);
        List<BarCodeEncryptionVO> encryptionVOS = barCodes.stream().map(barCode -> {
            String encryptionType = BarCodeSubUtil.subLastChar(barCode);
            IEncryption iEncryption = EncryptionEnum.of(encryptionType);
            String cipherBarCode = iEncryption.plainTextEncrypt(BarCodeSubUtil.removeLastChar(barCode));
            return new BarCodeEncryptionVO((String)barCode, cipherBarCode + encryptionType);
        }).collect(Collectors.toList());
        return encryptionVOS;
    }
}

