/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.handler.WriteHandler;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.rpc.service.BaseInvokeExcelItemExecuteService;
import com.els.modules.system.service.ExcelItemExcelService;
import com.els.modules.system.util.ExcelCellStyleStrategy;
import com.els.modules.system.util.ExcelDataListener;
import com.els.modules.system.util.ExcelDictWriteHandler;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelItemExcelServiceImpl
implements ExcelItemExcelService {
    @Resource
    private BaseInvokeExcelItemExecuteService baseInvokeExcelItemExecuteService;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;

    private List<TemplateConfigItem> getTemplate(String headId, String groupCode, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        List itemList = excelItemByConfigRpcService.getTemplate(headId).getTemplateConfigItemList();
        List<Object> listNew = SysUtil.copyProperties((List)itemList, TemplateConfigItem.class);
        if (StringUtils.isBlank((CharSequence)groupCode)) {
            return listNew;
        }
        listNew = listNew.stream().filter(item -> groupCode.equals(item.getGroupCode())).collect(Collectors.toList());
        return listNew;
    }

    private List<ExcelDetail> getExcelDetail(String headId, String groupCode, String roleCode, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        ArrayList<ExcelDetail> detailList = new ArrayList<ExcelDetail>();
        List<TemplateConfigItem> itemList = this.getTemplate(headId, groupCode, excelItemByConfigRpcService);
        if (CollectionUtil.isNotEmpty(itemList)) {
            String SALE = "sale";
            int index = 1;
            for (TemplateConfigItem item : itemList) {
                boolean editFlag;
                boolean showFlag = SALE.equals(roleCode) ? "1".equals(item.getSaleShow()) : "1".equals(item.getPurchaseShow());
                if (!showFlag) continue;
                ExcelDetail detail = new ExcelDetail();
                detail.setElsAccount(item.getElsAccount());
                detail.setColumnCode(item.getFieldName());
                detail.setColumnName(item.getFieldLabel());
                detail.setColumnIndex(index++);
                boolean bl = editFlag = SALE.equals(roleCode) ? "1".equals(item.getSaleEdit()) : "1".equals(item.getPurchaseEdit());
                if (editFlag && "1".equals(item.getRequired())) {
                    detail.setRequired(CommonConstant.STATUS_YES);
                }
                detail.setPrimaryKey(CommonConstant.STATUS_NO);
                detail.setDataType(ExcelDataTypeEnum.STRING.getCode());
                if (!(!StringUtils.isNotBlank((CharSequence)item.getDictCode()) || item.getDictCode().contains(",") && item.getDictCode().contains("#"))) {
                    detail.setDataType(ExcelDataTypeEnum.DICT.getCode());
                    detail.setDataFormat(item.getDictCode());
                } else if ("number".equals(item.getFieldType()) || "float".equals(item.getFieldType()) || "computed".equals(item.getFieldType())) {
                    detail.setDataType(ExcelDataTypeEnum.NUMBER.getCode());
                } else if ("date".equals(item.getFieldType())) {
                    detail.setDataType(ExcelDataTypeEnum.DATE.getCode());
                    detail.setDataFormat(item.getDataFormat());
                }
                detailList.add(detail);
            }
        }
        return detailList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> getExportData(String headId, List<ExcelDetail> detailList, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        String elsAccount = detailList.get(0).getElsAccount();
        List result = excelItemByConfigRpcService.getExportData(headId);
        if (!CollectionUtil.isNotEmpty((Collection)result)) return result;
        Map<String, String> dictMap = detailList.stream().filter(detail -> ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())).collect(Collectors.toMap(ExcelDetail::getColumnCode, ExcelDetail::getDataFormat));
        HashMap<String, List> listMap = new HashMap<String, List>();
        for (String string : dictMap.values()) {
            List dictList;
            if (listMap.containsKey(string)) continue;
            if (string.contains("#") || string.contains(",")) {
                String[] params = null;
                params = string.contains("#") ? string.split("#") : string.split(",");
                if (params.length < 3) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent((String[])sqlInjCheck);
                if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
                String string2 = params[3];
                SqlInjectionUtil.filterContent((String)string2);
                dictList = this.invokeBaseRpcService.queryTableDictListByFilterSql(TenantContext.getTenant(), params[0], params[1], params[2], string2);
            } else {
                dictList = this.invokeBaseRpcService.queryDictItemsByCode(string, TenantContext.getTenant());
            }
            listMap.put(string, dictList);
        }
        Object data = result.get(0);
        if (data instanceof Map) {
            for (Object object : result) {
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!dictMap.containsKey(key)) continue;
                    List dictList = (List)listMap.get(dictMap.get(key));
                    this.translation((List<DictDTO>)dictList, map, key);
                }
            }
            return result;
        } else {
            Field[] fieldArray = ConvertUtils.getAllFields(data);
            for (Object object : result) {
                for (Field field : fieldArray) {
                    if (!dictMap.containsKey(field.getName())) continue;
                    List dictList = (List)listMap.get(dictMap.get(field.getName()));
                    this.translation((List<DictDTO>)dictList, object, field);
                }
            }
        }
        return result;
    }

    private void translation(List<DictDTO> dictList, Object object, Field field) {
        try {
            field.setAccessible(true);
            String value = (String)field.get(object);
            for (DictDTO model : dictList) {
                if (!model.getValue().equals(value)) continue;
                field.set(object, model.getText());
                return;
            }
        }
        catch (Exception e) {
            throw new ELSBootException("\u53cd\u5c04\u5f02\u5e38", (Throwable)e, new String[0]);
        }
    }

    private void translation(List<DictDTO> dictList, Map map, String key) {
        for (DictDTO model : dictList) {
            if (!model.getValue().equals(map.get(key))) continue;
            map.put(key, model.getText());
            return;
        }
    }

    private List<String> includeColumn(List<ExcelDetail> detailList) {
        return detailList.stream().map(ExcelDetail::getColumnCode).collect(Collectors.toList());
    }

    @Override
    public void download(HttpServletResponse response, String headId, String groupCode, String handlerName, String roleCode) {
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(handlerName);
        List<ExcelDetail> detailList = this.getExcelDetail(headId, groupCode, roleCode, excelItemByConfigRpcService);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u5165\u6a21\u677f.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList)).head(ExcelHeaderUtil.getHeaderList(detailList)).sheet("data").doWrite(new ArrayList(16));
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @Override
    public void exportExcel(HttpServletResponse response, String headId, String groupCode, String handlerName, String roleCode) {
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(handlerName);
        List<ExcelDetail> detailList = this.getExcelDetail(headId, groupCode, roleCode, excelItemByConfigRpcService);
        List<Object> data = this.getExportData(headId, detailList, excelItemByConfigRpcService);
        List<String> includeColumnSet = this.includeColumn(detailList);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u51fa\u6570\u636e.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList)).includeColumnFiledNames(includeColumnSet).head(ExcelHeaderUtil.getHeaderList(detailList)).sheet("data").doWrite(data);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> importExcel(String headId, String groupCode, String handlerName, MultipartFile file, String roleCode) {
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(handlerName);
        List<ExcelDetail> detailList = this.getExcelDetail(headId, groupCode, roleCode, excelItemByConfigRpcService);
        ExcelDataListener listener = new ExcelDataListener((ExcelImportRpcService)excelItemByConfigRpcService, detailList, null);
        try (InputStream inputStream = file.getInputStream();){
            EasyExcel.read((InputStream)inputStream, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(2)).doRead();
            List<Map<String, Object>> list = listener.getImportDataList();
            return list;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }
}

