/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.els.modules.attachment.oss.config.OSSConfigure;
import com.els.modules.attachment.oss.factory.OSSClientFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSManageUtil {
    private static final Logger logger = LoggerFactory.getLogger(OSSManageUtil.class);
    private static OSSConfigure configure = OSSConfigure.getOOSconfigure();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String remotePath, OutputStream outputStream) throws Exception {
        OSSClient ossClient = OSSClientFactory.create();
        InputStream inputStream = null;
        try {
            int len;
            if (remotePath.startsWith(File.separator)) {
                remotePath = remotePath.substring(1, remotePath.length());
            }
            OSSObject object = ossClient.getObject(configure.getBucketName(), remotePath);
            inputStream = object.getObjectContent();
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
            ossClient.shutdown();
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteFile(String remotePath) {
        OSSClient ossClient = OSSClientFactory.create();
        if (remotePath.startsWith(File.separator)) {
            remotePath = remotePath.substring(1, remotePath.length());
        }
        ossClient.deleteObject(configure.getBucketName(), remotePath);
        ossClient.shutdown();
        logger.info("Delete File Successful ! filePath :" + remotePath);
    }

    public static void deleteFileBatch(List<String> remotePaths) {
        if (CollectionUtil.isEmpty(remotePaths)) {
            return;
        }
        OSSClient ossClient = OSSClientFactory.create();
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : remotePaths) {
            if (key.startsWith(File.separator)) {
                key = key.substring(1, key.length());
            }
            keys.add(key);
        }
        DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(configure.getBucketName()).withKeys(keys).withEncodingType("url"));
        List deletedObjects = deleteObjectsResult.getDeletedObjects();
        try {
            for (String obj : deletedObjects) {
                String deleteObj = URLDecoder.decode(obj, "UTF-8");
                System.out.println(deleteObj);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        ossClient.shutdown();
    }

    public static String contentType(String FilenameExtension) {
        if (FilenameExtension.equals("BMP") || FilenameExtension.equals("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals("GIF") || FilenameExtension.equals("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equals("JPEG") || FilenameExtension.equals("jpeg") || FilenameExtension.equals("JPG") || FilenameExtension.equals("jpg") || FilenameExtension.equals("PNG") || FilenameExtension.equals("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals("HTML") || FilenameExtension.equals("html")) {
            return "text/html";
        }
        if (FilenameExtension.equals("TXT") || FilenameExtension.equals("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equals("VSD") || FilenameExtension.equals("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals("PPTX") || FilenameExtension.equals("pptx") || FilenameExtension.equals("PPT") || FilenameExtension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("DOCX") || FilenameExtension.equals("docx") || FilenameExtension.equals("DOC") || FilenameExtension.equals("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equals("XML") || FilenameExtension.equals("xml")) {
            return "text/xml";
        }
        return "text/html";
    }

    public static String uploadFile(byte[] bytes, String fileName, String remotePath) {
        OSSClient ossClient = OSSClientFactory.create();
        String remoteFilePath = remotePath.substring(0, remotePath.length()).replaceAll("\\\\", "/");
        if (remoteFilePath.startsWith(File.separator)) {
            remoteFilePath = remoteFilePath.substring(1, remotePath.length());
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength((long)bytes.length);
        objectMetadata.setCacheControl("no-cache");
        objectMetadata.setHeader("Pragma", (Object)"no-cache");
        objectMetadata.setContentType(OSSManageUtil.contentType(fileName.substring(fileName.lastIndexOf("."))));
        objectMetadata.setContentDisposition("inline;filename=" + fileName);
        ossClient.putObject(configure.getBucketName(), remoteFilePath, (InputStream)new ByteArrayInputStream(bytes));
        ossClient.shutdown();
        return remoteFilePath + fileName;
    }
}

