/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private List<Map<String, Object>> importDataList = new ArrayList<Map<String, Object>>(16);
    private Map<String, Object> primaryMap = new HashMap<String, Object>(16);
    private List<ExcelDetail> excelDetailList;
    private ExcelImportRpcService service;
    private InvokeBaseRpcService invokeBaseRpcService;
    private String dataKey;

    public ExcelDataListener(ExcelImportRpcService service, List<ExcelDetail> excelDetailList, String dataKey, InvokeBaseRpcService invokeBaseRpcService) {
        this.service = service;
        this.excelDetailList = excelDetailList;
        this.dataKey = dataKey;
        this.invokeBaseRpcService = invokeBaseRpcService;
    }

    public List<Map<String, Object>> getImportDataList() {
        return this.importDataList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDictValue(ExcelDetail detail, String val) {
        String dictCode = detail.getDataFormat();
        if (!dictCode.contains("#")) {
            if (!dictCode.contains(",")) return this.invokeBaseRpcService.queryDictCodeByText(dictCode, val, detail.getElsAccount());
        }
        String[] params = null;
        params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
        if (params.length < 3) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
        SqlInjectionUtil.filterContent((String[])sqlInjCheck);
        if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
        String filterSql = params[3] + " and " + params[1] + " = '" + val + "'";
        SqlInjectionUtil.filterContent((String)filterSql);
        return this.invokeBaseRpcService.queryTableDictItemsByValue(params[0], params[1], params[2], filterSql, val, detail.getElsAccount());
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        StringBuilder primaryKey = new StringBuilder();
        for (ExcelDetail detail : this.excelDetailList) {
            Integer index = detail.getColumnIndex() - 1;
            if (data.containsKey(index) && StrUtil.isNotBlank((CharSequence)data.get(index))) {
                String val = data.get(index);
                if (ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) {
                    StringBuffer temVal = new StringBuffer("");
                    if (StrUtil.isNotBlank((CharSequence)val) && val.contains(",")) {
                        String[] split = val.split(",");
                        for (int i = 0; i < split.length; ++i) {
                            String dictValue;
                            if (!StrUtil.isNotBlank((CharSequence)split[i]) || !StrUtil.isNotBlank((CharSequence)(dictValue = this.getDictValue(detail, split[i])))) continue;
                            temVal.append(dictValue).append(",");
                        }
                    } else {
                        temVal.append(this.getDictValue(detail, val));
                    }
                    val = temVal.toString();
                    if (val.endsWith(",")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    if (StrUtil.isBlank((CharSequence)val)) {
                        throw new ELSBootException(I18nUtil.translate((String)"", (String)(detail.getColumnName() + "[" + data.get(index) + "]\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u5b57\u5178\u7f16\u7801[" + detail.getDataFormat() + "]\u8303\u56f4\u5185")));
                    }
                }
                try {
                    Double dVal = Double.valueOf(val);
                    BigDecimal bVal = BigDecimal.valueOf(dVal).setScale(4, 4);
                    dataMap.put(detail.getColumnCode(), bVal.stripTrailingZeros().toPlainString());
                }
                catch (NumberFormatException e) {
                    dataMap.put(detail.getColumnCode(), val);
                }
                if (!CommonConstant.STATUS_YES.equals(detail.getPrimaryKey())) continue;
                primaryKey.append(data.get(index)).append(",");
                continue;
            }
            if (!CommonConstant.STATUS_YES.equals(detail.getRequired())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)(detail.getColumnName() + "\u662f\u5fc5\u586b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a")));
        }
        if (StrUtil.isNotBlank((CharSequence)primaryKey.toString())) {
            if (this.primaryMap.containsKey(primaryKey.toString())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)(primaryKey + "\u552f\u4e00\u952e\u91cd\u590d")));
            }
            this.primaryMap.put(primaryKey.toString(), CommonConstant.STATUS_YES);
        }
        dataMap.put("els_account", TenantContext.getTenant());
        this.importDataList.add(dataMap);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (StrUtil.isBlank((CharSequence)this.dataKey)) {
            this.service.importExcel(this.importDataList);
        } else {
            RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
            redisUtil.set(this.dataKey, this.importDataList);
        }
    }
}

