/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.config;

import com.aliyun.oss.ClientConfiguration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class OSSConfigure {
    private static OSSConfigure configure = new OSSConfigure();
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private ClientConfiguration configuration;

    public static OSSConfigure getOOSconfigure() {
        if (configure == null) {
            configure = new OSSConfigure();
        }
        return configure;
    }

    public OSSConfigure() {
        Properties prop = this.getOSSProperties();
        this.endpoint = prop.getProperty("oss.endpointNet").trim();
        this.accessKeyId = prop.getProperty("oss.accessKeyId").trim();
        this.accessKeySecret = prop.getProperty("oss.accessKeySecret").trim();
        this.bucketName = prop.getProperty("oss.bucketName").trim();
        String maxConnections = prop.getProperty("oss.maxConnections").trim();
        String connectionTimeout = prop.getProperty("oss.connectionTimeout").trim();
        String socketTimeout = prop.getProperty("oss.socketTimeout").trim();
        String maxErrorRetry = prop.getProperty("oss.maxErrorRetry").trim();
        this.configuration = new ClientConfiguration();
        this.configuration.setMaxConnections(Integer.parseInt(maxConnections));
        this.configuration.setConnectionTimeout(Integer.parseInt(connectionTimeout));
        this.configuration.setSocketTimeout(Integer.parseInt(socketTimeout));
        this.configuration.setMaxErrorRetry(Integer.parseInt(maxErrorRetry));
    }

    public OSSConfigure(String endpoint, String accessKeyId, String accessKeySecret, String bucketName) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.bucketName = bucketName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getOSSProperties() {
        Properties properties = null;
        InputStreamReader propertyIn = null;
        try {
            propertyIn = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("oss.properties"), "UTF-8");
            properties = new Properties();
            properties.load(propertyIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (properties != null) {
                try {
                    propertyIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setConfiguration(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OSSConfigure)) {
            return false;
        }
        OSSConfigure other = (OSSConfigure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        ClientConfiguration this$configuration = this.getConfiguration();
        ClientConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OSSConfigure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        ClientConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    public String toString() {
        return "OSSConfigure(endpoint=" + this.getEndpoint() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", bucketName=" + this.getBucketName() + ", configuration=" + this.getConfiguration() + ")";
    }
}

