/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.vo.ElsCompanySetVO;
import com.els.modules.system.vo.ElsSetVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e"})
@RestController
@RequestMapping(value={"/base/companySet"})
public class ElsCompanySetController
extends BaseController<ElsCompanySet, ElsCompanySetService> {
    @Autowired
    private ElsCompanySetService elsCompanySetService;

    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868", notes="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @GetMapping(value={"/findList"})
    public Result<?> findList() {
        ElsSetVO setVO = new ElsSetVO();
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(this.getTenantId());
        list.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getItemDescI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemDesc())) {
                item.setItemDesc(I18nUtil.translate((String)item.getItemDescI18nKey(), (String)item.getItemDesc()));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getItemNameI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemName())) {
                item.setItemName(I18nUtil.translate((String)item.getItemNameI18nKey(), (String)item.getItemName()));
            }
        });
        setVO.setCompanySetList(list);
        return Result.ok((Object)setVO);
    }

    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u4fdd\u5b58")
    @ApiOperation(value="\u4fdd\u5b58", notes="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public Result<?> save(@RequestBody ElsSetVO setVO) {
        this.elsCompanySetService.save(setVO.getCompanySetList());
        return this.commonSuccessResult(3);
    }
}

