/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.modules.attachment.oss.service.IAttachmnetService;
import com.els.modules.attachment.oss.utils.OSSManageUtil;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="aliCloudOssFileServiceImpl")
public class AliCloudOssFileServiceImpl
implements IAttachmnetService {
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @Override
    public String uploadFile(MultipartFile uploadFile, String remothPath) throws IOException {
        String documentName = uploadFile.getOriginalFilename();
        return OSSManageUtil.uploadFile(uploadFile.getBytes(), documentName, remothPath);
    }

    @Override
    public void downloadFile(OutputStream outputStream, String filePath) throws FileNotFoundException, Exception {
        OSSManageUtil.downloadFile(filePath, outputStream);
    }

    @Override
    public void delete(String filePath) {
        String remotePath = this.uploadpath + filePath;
        OSSManageUtil.deleteFile(remotePath);
    }

    @Override
    public void deleteBatch(List<String> filePaths) {
        if (CollectionUtil.isNotEmpty(filePaths)) {
            ArrayList<String> remotePaths = new ArrayList<String>();
            for (String filePath : filePaths) {
                remotePaths.add(this.uploadpath + filePath);
            }
            if (CollectionUtil.isNotEmpty(remotePaths)) {
                OSSManageUtil.deleteFileBatch(remotePaths);
            }
        }
    }
}

