/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.ElsBarcodeTemplateHead;
import com.els.modules.barcode.entity.ElsBarcodeTemplateItem;
import com.els.modules.barcode.entity.PurchaseBarcodePoolHead;
import com.els.modules.barcode.entity.PurchaseBarcodePoolRecord;
import com.els.modules.barcode.entity.PurchaseBarcodePrintHead;
import com.els.modules.barcode.entity.PurchaseBarcodePrintItem;
import com.els.modules.barcode.enumerate.BarcodePrintStatusEnum;
import com.els.modules.barcode.mapper.ElsBarcodeTemplateHeadMapper;
import com.els.modules.barcode.mapper.ElsBarcodeTemplateItemMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolRecordMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePrintHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePrintItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.PurchaseBarcodePoolRecordService;
import com.els.modules.barcode.vo.BarcodeRecordVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBarcodePoolRecordServiceImpl
extends BaseServiceImpl<PurchaseBarcodePoolRecordMapper, PurchaseBarcodePoolRecord>
implements PurchaseBarcodePoolRecordService {
    @Autowired
    private PurchaseBarcodePoolRecordMapper purchaseBarcodePoolRecordMapper;
    @Autowired
    private ElsBarcodeTemplateHeadMapper elsBarcodeTemplateHeadMapper;
    @Autowired
    private ElsBarcodeTemplateItemMapper elsBarcodeTemplateItemMapper;
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;
    @Autowired
    private PurchaseBarcodePrintHeadMapper purchaseBarcodePrintHeadMapper;
    @Autowired
    private PurchaseBarcodePrintItemMapper purchaseBarcodePrintItemMapper;

    @Override
    public List<PurchaseBarcodePoolRecord> selectByMainId(String mainId) {
        return this.purchaseBarcodePoolRecordMapper.selectByMainId(mainId);
    }

    @Override
    public void saveBatchByBarcode(BarcodeRecordVO barcodeRecordVO) {
        ElsBarcodeTemplateHead elsBarcodeTemplateHead = (ElsBarcodeTemplateHead)((Object)this.elsBarcodeTemplateHeadMapper.selectById((Serializable)((Object)barcodeRecordVO.getTemplateId())));
        List<ElsBarcodeTemplateItem> elsBarcodeTemplateItemList = this.elsBarcodeTemplateItemMapper.selectByMainId(barcodeRecordVO.getTemplateId());
        elsBarcodeTemplateItemList = elsBarcodeTemplateItemList.stream().filter(item -> "BARCODE".equals(item.getDesignType())).collect(Collectors.toList());
        ArrayList<String> barcodeList = new ArrayList<String>();
        for (ElsBarcodeTemplateItem templateItem : elsBarcodeTemplateItemList) {
            barcodeList.addAll(Arrays.asList(templateItem.getDatasource().split(",")));
        }
        if (barcodeList != null && barcodeList.size() > 0) {
            ArrayList<PurchaseBarcodePoolRecord> recordList = new ArrayList<PurchaseBarcodePoolRecord>();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(PurchaseBarcodePoolHead::getBarcode, barcodeList);
            List poolHeadList = this.purchaseBarcodePoolHeadService.list((Wrapper)queryWrapper);
            for (PurchaseBarcodePoolHead poolHead : poolHeadList) {
                PurchaseBarcodePoolRecord record = new PurchaseBarcodePoolRecord();
                record.setHeadId(poolHead.getId());
                record.setBusinessNumber(barcodeRecordVO.getBusinessNumber());
                record.setBusinessType(barcodeRecordVO.getBusinessType());
                record.setBusinessStatus(barcodeRecordVO.getBusinessStatus());
                record.setOperateTime(new Date());
                record.setOperation("\u6253\u5370\uff0c\u6253\u5370\u4efd\u6570\uff1a" + elsBarcodeTemplateHead.getPrintNumber());
                record.setOperator(SysUtil.getUserRealName());
                recordList.add(record);
                poolHead.setPrintedNumber(poolHead.getPrintedNumber() != null ? poolHead.getPrintedNumber() + Integer.parseInt(elsBarcodeTemplateHead.getPrintNumber()) : Integer.parseInt(elsBarcodeTemplateHead.getPrintNumber()));
            }
            this.saveBatch(recordList);
            this.purchaseBarcodePoolHeadService.saveOrUpdateBatch(poolHeadList);
        }
    }

    @Override
    public void saveBatchBarcodeByPrint(BarcodeRecordVO barcodeRecordVO) {
        PurchaseBarcodePrintHead purchaseBarcodePrintHead = (PurchaseBarcodePrintHead)((Object)this.purchaseBarcodePrintHeadMapper.selectById((Serializable)((Object)barcodeRecordVO.getTemplateId())));
        List<PurchaseBarcodePrintItem> purchaseBarcodePrintItemList = this.purchaseBarcodePrintItemMapper.selectByMainId(barcodeRecordVO.getTemplateId());
        purchaseBarcodePrintItemList = purchaseBarcodePrintItemList.stream().filter(item -> "BARCODE".equals(item.getElementType())).collect(Collectors.toList());
        ArrayList<String> barcodeList = new ArrayList<String>();
        for (PurchaseBarcodePrintItem printItem : purchaseBarcodePrintItemList) {
            barcodeList.addAll(Arrays.asList(printItem.getDatasource().split(",")));
        }
        if (barcodeList != null && barcodeList.size() > 0) {
            ArrayList<PurchaseBarcodePoolRecord> recordList = new ArrayList<PurchaseBarcodePoolRecord>();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(PurchaseBarcodePoolHead::getBarcode, barcodeList);
            List poolHeadList = this.purchaseBarcodePoolHeadService.list((Wrapper)queryWrapper);
            for (PurchaseBarcodePoolHead poolHead : poolHeadList) {
                if ("1".equals(purchaseBarcodePrintHead.getRecord())) {
                    PurchaseBarcodePoolRecord record = new PurchaseBarcodePoolRecord();
                    record.setHeadId(poolHead.getId());
                    record.setBusinessNumber(barcodeRecordVO.getBusinessNumber());
                    record.setBusinessType(barcodeRecordVO.getBusinessType());
                    record.setBusinessStatus(barcodeRecordVO.getBusinessStatus());
                    record.setOperateTime(new Date());
                    record.setOperation("\u6253\u5370\uff0c\u6253\u5370\u4efd\u6570\uff1a" + purchaseBarcodePrintHead.getPrintNumber());
                    record.setOperator(SysUtil.getUserRealName());
                    recordList.add(record);
                }
                poolHead.setPrintedNumber(poolHead.getPrintedNumber() != null ? poolHead.getPrintedNumber() + Integer.parseInt(purchaseBarcodePrintHead.getPrintNumber()) : Integer.parseInt(purchaseBarcodePrintHead.getPrintNumber()));
            }
            if ("1".equals(purchaseBarcodePrintHead.getRecord())) {
                this.saveBatch(recordList);
            }
            this.purchaseBarcodePoolHeadService.saveOrUpdateBatch(poolHeadList);
        }
        purchaseBarcodePrintHead.setStatus(BarcodePrintStatusEnum.FINAL.getValue());
        this.purchaseBarcodePrintHeadMapper.updateById((Object)purchaseBarcodePrintHead);
    }
}

