/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.SaleBarcodePoolHead;
import com.els.modules.barcode.entity.SaleBarcodePoolRecord;
import com.els.modules.barcode.entity.SaleBarcodePrintHead;
import com.els.modules.barcode.entity.SaleBarcodePrintItem;
import com.els.modules.barcode.enumerate.BarcodePrintStatusEnum;
import com.els.modules.barcode.mapper.SaleBarcodePoolRecordMapper;
import com.els.modules.barcode.mapper.SaleBarcodePrintHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodePrintItemMapper;
import com.els.modules.barcode.service.SaleBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodePoolRecordService;
import com.els.modules.barcode.vo.BarcodeRecordVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleBarcodePoolRecordServiceImpl
extends BaseServiceImpl<SaleBarcodePoolRecordMapper, SaleBarcodePoolRecord>
implements SaleBarcodePoolRecordService {
    @Autowired
    private SaleBarcodePoolRecordMapper saleBarcodePoolRecordMapper;
    @Autowired
    private SaleBarcodePrintHeadMapper saleBarcodePrintHeadMapper;
    @Autowired
    private SaleBarcodePrintItemMapper saleBarcodePrintItemMapper;
    @Autowired
    private SaleBarcodePoolHeadService saleBarcodePoolHeadService;

    @Override
    public List<SaleBarcodePoolRecord> selectByMainId(String mainId) {
        return this.saleBarcodePoolRecordMapper.selectByMainId(mainId);
    }

    @Override
    public void saveBatchBarcodeByPrint(BarcodeRecordVO barcodeRecordVO) {
        SaleBarcodePrintHead saleBarcodePrintHead = (SaleBarcodePrintHead)((Object)this.saleBarcodePrintHeadMapper.selectById((Serializable)((Object)barcodeRecordVO.getTemplateId())));
        List<SaleBarcodePrintItem> saleBarcodePrintItemList = this.saleBarcodePrintItemMapper.selectByMainId(barcodeRecordVO.getTemplateId());
        saleBarcodePrintItemList = saleBarcodePrintItemList.stream().filter(item -> "BARCODE".equals(item.getElementType())).collect(Collectors.toList());
        ArrayList<String> barcodeList = new ArrayList<String>();
        for (SaleBarcodePrintItem printItem : saleBarcodePrintItemList) {
            barcodeList.addAll(Arrays.asList(printItem.getDatasource().split(",")));
        }
        if (barcodeList != null && barcodeList.size() > 0) {
            ArrayList<SaleBarcodePoolRecord> recordList = new ArrayList<SaleBarcodePoolRecord>();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(SaleBarcodePoolHead::getBarcode, barcodeList);
            List poolHeadList = this.saleBarcodePoolHeadService.list((Wrapper)queryWrapper);
            for (SaleBarcodePoolHead poolHead : poolHeadList) {
                if ("1".equals(saleBarcodePrintHead.getRecord())) {
                    SaleBarcodePoolRecord record = new SaleBarcodePoolRecord();
                    record.setHeadId(poolHead.getId());
                    record.setBusinessNumber(barcodeRecordVO.getBusinessNumber());
                    record.setBusinessType(barcodeRecordVO.getBusinessType());
                    record.setBusinessStatus(barcodeRecordVO.getBusinessStatus());
                    record.setOperateTime(new Date());
                    record.setOperation("\u6253\u5370\uff0c\u6253\u5370\u4efd\u6570\uff1a" + saleBarcodePrintHead.getPrintNumber());
                    record.setOperator(SysUtil.getUserRealName());
                    recordList.add(record);
                }
                poolHead.setPrintedNumber(poolHead.getPrintedNumber() != null ? poolHead.getPrintedNumber() + Integer.parseInt(saleBarcodePrintHead.getPrintNumber()) : Integer.parseInt(saleBarcodePrintHead.getPrintNumber()));
            }
            if ("1".equals(saleBarcodePrintHead.getRecord())) {
                this.saveBatch(recordList);
            }
            this.saleBarcodePoolHeadService.saveOrUpdateBatch(poolHeadList);
        }
        saleBarcodePrintHead.setStatus(BarcodePrintStatusEnum.FINAL.getValue());
        this.saleBarcodePrintHeadMapper.updateById((Object)saleBarcodePrintHead);
    }
}

