/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.SaleBarcodePrintHead;
import com.els.modules.barcode.entity.SaleBarcodePrintItem;
import com.els.modules.barcode.enumerate.BarcodePrintStatusEnum;
import com.els.modules.barcode.mapper.SaleBarcodePrintHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodePrintItemMapper;
import com.els.modules.barcode.service.SaleBarcodePrintHeadService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleBarcodePrintHeadServiceImpl
extends BaseServiceImpl<SaleBarcodePrintHeadMapper, SaleBarcodePrintHead>
implements SaleBarcodePrintHeadService {
    @Autowired
    private SaleBarcodePrintHeadMapper saleBarcodePrintHeadMapper;
    @Autowired
    private SaleBarcodePrintItemMapper saleBarcodePrintItemMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleBarcodePrintHead saleBarcodePrintHead, List<SaleBarcodePrintItem> saleBarcodePrintItemList) {
        saleBarcodePrintHead.setNumber(this.codeGeneratorService.getNextCode("srmBarcodePrintNumber", (Object)saleBarcodePrintHead));
        saleBarcodePrintHead.setStatus(BarcodePrintStatusEnum.NEW.getValue());
        saleBarcodePrintHead.setRecord(StringUtils.isBlank((CharSequence)saleBarcodePrintHead.getRecord()) ? "0" : saleBarcodePrintHead.getRecord());
        this.saleBarcodePrintHeadMapper.insert((Object)saleBarcodePrintHead);
        this.insertData(saleBarcodePrintHead, saleBarcodePrintItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleBarcodePrintHead saleBarcodePrintHead, List<SaleBarcodePrintItem> saleBarcodePrintItemList) {
        this.saleBarcodePrintHeadMapper.updateById((Object)saleBarcodePrintHead);
        this.saleBarcodePrintItemMapper.deleteByMainId(saleBarcodePrintHead.getId());
        this.insertData(saleBarcodePrintHead, saleBarcodePrintItemList);
    }

    private void insertData(SaleBarcodePrintHead saleBarcodePrintHead, List<SaleBarcodePrintItem> saleBarcodePrintItemList) {
        if (saleBarcodePrintItemList != null && !saleBarcodePrintItemList.isEmpty()) {
            for (SaleBarcodePrintItem entity : saleBarcodePrintItemList) {
                entity.setHeadId(saleBarcodePrintHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleBarcodePrintHead);
            }
            this.saleBarcodePrintItemMapper.insertBatchSomeColumn(saleBarcodePrintItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleBarcodePrintItemMapper.deleteByMainId(id);
        this.saleBarcodePrintHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleBarcodePrintItemMapper.deleteByMainId(serializable.toString());
            this.saleBarcodePrintHeadMapper.deleteById(serializable);
        }
    }
}

