/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ipaas.controller;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.SrmToIPaasService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"SRM\u8c03\u7528iPaas\u5e73\u53f0"})
@RestController
@RequestMapping(value={"/ipaas/srmToIPaas"})
public class SrmToIPaasController {
    private static final Logger log = LoggerFactory.getLogger(SrmToIPaasController.class);
    @Autowired
    private SrmToIPaasService srmToIPaasService;

    @ApiOperation(value="\u670d\u52a1\u5305\u67e5\u8be2", notes="\u670d\u52a1\u5305\u67e5\u8be2")
    @GetMapping(value={"/servicePackList"})
    public Result<?> servicePackList(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        JSONObject data = new JSONObject();
        data.put("source", (Object)"0");
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "servicePack");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u670d\u52a1\u5957\u9910\u67e5\u8be2", notes="\u670d\u52a1\u5957\u9910\u67e5\u8be2")
    @GetMapping(value={"/selectServiceCombo"})
    public Result<?> selectServiceCombo(@RequestParam(value="servicePackId") String servicePackId, @RequestParam(value="priceType") String priceType) {
        JSONObject data = new JSONObject();
        data.put("servicePackId", (Object)servicePackId);
        data.put("priceType", (Object)priceType);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "serviceCombo");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u5145\u503c\u8bb0\u5f55", notes="\u5145\u503c\u8bb0\u5f55")
    @GetMapping(value={"/rechargeRecordList"})
    public Result<?> rechargeRecordList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "orderList");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u5f00\u901a\u8bb0\u5f55", notes="\u5f00\u901a\u8bb0\u5f55")
    @GetMapping(value={"/activationRecordList"})
    public Result<?> activationRecordList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "qualificationList");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u6d88\u8d39\u8bb0\u5f55", notes="\u6d88\u8d39\u8bb0\u5f55")
    @GetMapping(value={"/expensesRecordList"})
    public Result<?> expensesRecordList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "expensesList");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u5145\u503c\u521b\u5efa\u8ba2\u5355", notes="\u5145\u503c\u521b\u5efa\u8ba2\u5355")
    @GetMapping(value={"/rechargeCreateOrder"})
    public Result<?> rechargeCreateOrder(@RequestParam(value="orderType") String orderType, @RequestParam(value="rechargeAmount") BigDecimal rechargeAmount) {
        JSONObject data = new JSONObject();
        data.put("customerAccount", (Object)TenantContext.getTenant());
        data.put("customerName", (Object)SysUtil.getLoginUser().getEnterpriseName());
        data.put("orderType", (Object)orderType);
        data.put("rechargeAmount", (Object)rechargeAmount);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "createOrder", "recharge");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u670d\u52a1\u5957\u9910\u521b\u5efa\u8ba2\u5355", notes="\u670d\u52a1\u5957\u9910\u521b\u5efa\u8ba2\u5355")
    @GetMapping(value={"/comboCreateOrder"})
    public Result<?> comboCreateOrder(@RequestParam(value="serviceComboId") String serviceComboId, @RequestParam(value="orderType") String orderType, @RequestParam(value="orderPrice") BigDecimal orderPrice, @RequestParam(value="comboQualification") Integer comboQualification) {
        JSONObject data = new JSONObject();
        data.put("serviceComboId", (Object)serviceComboId);
        data.put("customerAccount", (Object)TenantContext.getTenant());
        data.put("customerName", (Object)SysUtil.getLoginUser().getEnterpriseName());
        data.put("orderType", (Object)orderType);
        data.put("orderPrice", (Object)orderPrice);
        data.put("comboQualification", (Object)comboQualification);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "createOrder", "combo");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5", notes="\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/orderDetail"})
    public Result<?> orderDetail(@RequestParam(value="id") String id) {
        JSONObject data = new JSONObject();
        data.put("orderId", (Object)id);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "orderDetail");
        return Result.ok((Object)result.getJSONObject("data"));
    }

    @ApiOperation(value="\u786e\u8ba4\u8ba2\u5355", notes="\u786e\u8ba4\u8ba2\u5355")
    @GetMapping(value={"/confirmOrder"})
    public Result<?> confirmOrder(@RequestParam(value="orderId") String orderId) {
        JSONObject data = new JSONObject();
        data.put("orderId", (Object)orderId);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "confirmOrder");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u4f5c\u5e9f\u8ba2\u5355", notes="\u4f5c\u5e9f\u8ba2\u5355")
    @GetMapping(value={"/cancelOrder"})
    public Result<?> cancelOrder(@RequestParam(value="orderId") String orderId) {
        JSONObject data = new JSONObject();
        data.put("orderId", (Object)orderId);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "cancelOrder");
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u8ba2\u5355\u4e0a\u4f20\u6587\u4ef6", notes="\u8ba2\u5355\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/uploadOrderFile"})
    public Result<?> uploadOrderFile(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        Assert.hasText((String)headId, (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            Iterator iterator = fileMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entity = iterator.next();
                JSONObject data = new JSONObject();
                data.put("orderId", (Object)headId);
                data.put("fileString", (Object)Base64.encode((byte[])((MultipartFile)entity.getValue()).getBytes()));
                data.put("fileName", (Object)((MultipartFile)entity.getValue()).getOriginalFilename());
                JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "attachment", "upload");
                return Result.ok((Object)result);
            }
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u5931\u8d25:", (Throwable)e);
            return Result.error((String)"\u4e0a\u4f20\u5931\u8d25");
        }
        return Result.error((String)"\u4e0a\u4f20\u5931\u8d25");
    }

    @ApiOperation(value="\u8ba2\u5355\u4e0b\u8f7d\u6587\u4ef6", notes="\u8ba2\u5355\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/downloadOrderFile"})
    public void downloadOrderFile(@RequestParam(name="fileId") String fileId, HttpServletResponse response) {
        JSONObject data = new JSONObject();
        data.put("fileId", (Object)fileId);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "attachment", "download");
        if (result.getBoolean("success").booleanValue()) {
            String fileString = result.getJSONObject("data").getString("data");
            try (ServletOutputStream outputStream = response.getOutputStream();){
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String("response".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
                Base64.decodeToStream((CharSequence)fileString, (OutputStream)outputStream, (boolean)false);
                outputStream.flush();
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:", (Throwable)e);
            }
        }
    }
}

