/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.vo.DictModel;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.mapper.DictItemMapper;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.model.TreeSelectModel;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, Dict>
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    @Resource
    private DictMapper dictMapper;
    @Resource
    private DictItemMapper dictItemMapper;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    private static final String CATALOGUE = "sys:cache:dict";
    private static final String COLON = ":";

    @Override
    public List<DictModel> queryDictItemsByCode(String code, String elsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(code);
        List<DictModel> list = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        if (code.toLowerCase().equals("materialgroup")) {
            log.info("elsAccount: " + elsAccount + " redis\u503c: " + (list != null ? list.toString() : null));
        }
        if (list == null) {
            log.info("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.dictMapper.queryDictItemsByCode(code, elsAccount);
            if (code.toLowerCase().equals("materialgroup")) {
                log.info("elsAccount: " + elsAccount + " list: " + list.toString());
            }
            if (CollectionUtil.isEmpty(list)) {
                list = this.dictMapper.queryDictItemsByCode(code, "100000");
                if (code.toLowerCase().equals("materialgroup")) {
                    log.info("qqtAccount: 100000" + elsAccount + " list: " + list.toString());
                }
            }
            this.redisUtil.set(redisKey.toString(), list, 7200L);
        }
        return list;
    }

    @Override
    public String queryDictTextByKey(String code, String key, String elsAccount) {
        List<DictModel> list = this.queryDictItemsByCode(code, elsAccount);
        if (CollectionUtil.isNotEmpty(list)) {
            for (DictModel dictModel : list) {
                if (!key.equals(dictModel.getValue())) continue;
                return dictModel.getText();
            }
        }
        return null;
    }

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code+':text='+#text", sync=true)
    public String queryDictValueByText(String code, String text) {
        log.info("\u65e0\u7f13\u5b58dictText\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        String val = this.dictMapper.queryDictValueByText(code, text, TenantContext.getTenant());
        if (StringUtils.isBlank((String)val)) {
            val = this.dictMapper.queryDictValueByText(code, text, "100000");
        }
        return val;
    }

    @Override
    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(table).append(text).append(code);
        List<DictModel> list = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        if (list == null) {
            log.info("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.dictMapper.queryTableDictItemsByCode(table, text, code);
            this.redisUtil.set(redisKey.toString(), list, 1800L);
        }
        return list;
    }

    @Override
    public List<DictModel> queryTableDictItemsByCodeAndFilter(String table, String text, String code, String filterSql, String elsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(text).append(code).append(filterSql);
        List list = (List)this.redisUtil.get(redisKey.toString());
        log.info("\u5b57\u5178\u7ffb\u8bd1,redisKey:" + redisKey.toString() + "-" + (list == null ? "null" : list.toString()));
        if (CollectionUtil.isEmpty((Collection)list)) {
            log.info("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.invokeBaseRpcService.queryTableDictListByFilterSql(elsAccount, table, text, code, filterSql);
            this.redisUtil.set(redisKey.toString(), (Object)list, 1800L);
        }
        return SysUtil.copyProperties((List)list, DictModel.class);
    }

    @Override
    @Cacheable(value={"sys:cache:dictTable"})
    public List<String> queryTableDictByKeys(String table, String text, String code, String[] keyArray) {
        List<DictModel> dicts = this.dictMapper.queryTableDictByKeys(table, text, code, keyArray);
        ArrayList<String> texts = new ArrayList<String>(dicts.size());
        block0: for (String key : keyArray) {
            for (DictModel dict : dicts) {
                if (!key.equals(dict.getValue())) continue;
                texts.add(dict.getText());
                continue block0;
            }
        }
        return texts;
    }

    @Override
    public boolean deleteByDictId(Dict sysDict) {
        sysDict.setDeleted(CommonConstant.DEL_FLAG_1);
        return this.updateById(sysDict);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(Dict sysDict, List<DictItem> sysDictItemList) {
        this.dictMapper.insert(sysDict);
        if (sysDictItemList != null) {
            for (DictItem entity : sysDictItemList) {
                entity.setDictId(sysDict.getId());
                this.dictItemMapper.insert(entity);
            }
        }
    }

    @Override
    public List<DictModel> queryAllDepartBackDictModel() {
        return ((DictMapper)this.baseMapper).queryAllDepartBackDictModel();
    }

    @Override
    public List<DictModel> queryAllUserBackDictModel() {
        return ((DictMapper)this.baseMapper).queryAllUserBackDictModel();
    }

    @Override
    public List<DictModel> queryTableDictItems(String table, String text, String code, String keyword) {
        return ((DictMapper)this.baseMapper).queryTableDictItems(table, text, code, "%" + keyword + "%");
    }

    @Override
    public List<TreeSelectModel> queryTreeList(Map<String, String> query, String table, String text, String code, String pidField, String pid, String hasChildField) {
        return ((DictMapper)this.baseMapper).queryTreeList(query, table, text, code, pidField, pid, hasChildField);
    }

    @Override
    public void deleteOneDictPhysically(String id) {
        ((DictMapper)this.baseMapper).deleteOneById(id);
        this.dictItemMapper.delete((Wrapper)new LambdaQueryWrapper().eq(DictItem::getDictId, (Object)id));
    }

    @Override
    public void updateDictDelFlag(int delFlag, String id) {
        ((DictMapper)this.baseMapper).updateDictDelFlag(delFlag, id);
    }

    @Override
    public List<Dict> queryDeleteList() {
        return ((DictMapper)this.baseMapper).queryDeleteList();
    }

    @Override
    public List<String> queryTableKeyword(String table, String column, String value) {
        return ((DictMapper)this.baseMapper).queryTableKeyword(table, column, "%" + value + "%");
    }

    @Override
    public String queryTableDictTextByFilterSql(String table, String text, String filterSql, String elsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(text).append(filterSql);
        String value = (String)this.redisUtil.get(redisKey.toString());
        if (StrUtil.isBlank((CharSequence)value)) {
            if (StrUtil.isBlank((CharSequence)filterSql)) {
                filterSql = "1 = 1";
            }
            StringBuilder sql = new StringBuilder(filterSql);
            sql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account")) {
                sql.append(" and els_account='").append(elsAccount).append("' ");
            }
            if (StrUtil.isBlank((CharSequence)(value = ((DictMapper)this.baseMapper).queryTableDictTextByFilterSql(table, text, sql.toString())))) {
                sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account")) {
                    sql.append(" and els_account='").append("100000").append("' ");
                }
                value = ((DictMapper)this.baseMapper).queryTableDictTextByFilterSql(table, text, sql.toString());
            }
            this.redisUtil.set(redisKey.toString(), (Object)value, 1800L);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryTableDictItemsByValue(String table, String text, String code, String filterSql, String val, String elsAccountParam) {
        try {
            String elsAccount = StrUtil.isBlank((CharSequence)elsAccountParam) ? TenantContext.getTenant() : elsAccountParam;
            TenantContext.setTenant((String)elsAccount);
            StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(code).append(filterSql);
            String value = (String)this.redisUtil.get(redisKey.toString());
            if (StrUtil.isBlank((CharSequence)value)) {
                if (StrUtil.isBlank((CharSequence)filterSql)) {
                    filterSql = "1 = 1";
                }
                StringBuilder sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account")) {
                    sql.append(" and els_account='").append(elsAccount).append("' ");
                }
                if (StrUtil.isBlank((CharSequence)(value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString())))) {
                    sql = new StringBuilder(filterSql);
                    sql.append(" and is_deleted = '0'");
                    if (!filterSql.contains("els_account")) {
                        sql.append(" and els_account='").append("100000").append("' ");
                    }
                    value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString());
                }
                this.redisUtil.set(redisKey.toString(), (Object)value, 1800L);
            }
            String string = value;
            return string;
        }
        finally {
            TenantContext.clear();
        }
    }

    @Override
    public void addDictI18nKey() {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().isNull(Dict::getDictNameI18nKey)).list();
        List list1 = ((LambdaQueryChainWrapper)this.dictItemService.lambdaQuery().isNull(DictItem::getItemTextI18nKey)).list();
        if (CollectionUtils.isEmpty((Collection)list) && CollectionUtils.isEmpty((Collection)list1)) {
            return;
        }
        ArrayList<String> collect = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            collect = list.parallelStream().map(o -> o.getDictName()).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            List collect1 = list1.parallelStream().map(o -> o.getItemText()).distinct().collect(Collectors.toList());
            collect.addAll(collect1);
        }
        if (!CollectionUtils.isEmpty(collect)) {
            Map<String, String> stringStringMap = this.i18nService.checkAndAdd(collect);
            list.forEach(item -> item.setDictNameI18nKey((String)stringStringMap.get(item.getDictName())));
            list1.forEach(item -> item.setItemTextI18nKey((String)stringStringMap.get(item.getItemText())));
            this.updateBatchById(list);
            this.dictItemService.updateBatchById(list1);
        }
    }
}

