/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.utils;

import com.els.modules.attachment.oss.config.COSConfigure;
import com.els.modules.attachment.oss.factory.COSClientFactory;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;

public class COSManageUtil {
    private static COSConfigure configure = new COSConfigure();

    public static String uploadFile(String remotePath, File localFile) {
        String remoteFilePath = remotePath.substring(0, remotePath.length()).replaceAll("\\\\", "/") + "/";
        PutObjectRequest putObjectRequest = new PutObjectRequest(configure.getBucketName(), remoteFilePath + localFile.getName(), localFile);
        putObjectRequest.setStorageClass(StorageClass.Standard);
        COSClient cc = COSClientFactory.create();
        try {
            PutObjectResult putObjectResult = cc.putObject(putObjectRequest);
            String etag = putObjectResult.getETag();
            System.out.println(etag);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        cc.shutdown();
        return null;
    }

    public static String uploadFileByStream(byte[] bytes, String remotePath, String fileName) {
        COSClient cosClient = COSClientFactory.create();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength((long)bytes.length);
        objectMetadata.setContentType(COSManageUtil.contentType(fileName.substring(fileName.lastIndexOf("."))));
        PutObjectResult putObjectResult = cosClient.putObject(configure.getBucketName(), remotePath, (InputStream)new ByteArrayInputStream(bytes), objectMetadata);
        String etag = putObjectResult.getETag();
        return etag;
    }

    public static String downLoadFileToLocal(String remotePath, String localPath) {
        File downFile = new File(localPath);
        COSClient cc = COSClientFactory.create();
        GetObjectRequest getObjectRequest = new GetObjectRequest(configure.getBucketName(), remotePath);
        ObjectMetadata downObjectMeta = cc.getObject(getObjectRequest, downFile);
        cc.shutdown();
        String etag = downObjectMeta.getETag();
        return etag;
    }

    public static void downLoadFileByStream(String remotePath, OutputStream outputStream) throws IOException {
        COSClient cosClient = COSClientFactory.create();
        GetObjectRequest getObjectRequest = new GetObjectRequest(configure.getBucketName(), remotePath);
        COSObject cosObject = cosClient.getObject(getObjectRequest);
        byte[] bytes = null;
        try (COSObjectInputStream cosObjectInput = cosObject.getObjectContent();){
            bytes = IOUtils.toByteArray((InputStream)cosObjectInput);
        }
        try {
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String bucketName, String key) {
        COSClient cc = COSClientFactory.create();
        try {
            cc.deleteObject(bucketName, key);
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        finally {
            cc.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bucket createBucket(String bucketName) throws CosClientException, CosServiceException {
        COSClient cc = COSClientFactory.create();
        Bucket bucket = null;
        try {
            bucket = cc.createBucket(bucketName);
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBucket(String bucketName) throws CosClientException, CosServiceException {
        COSClient cc = COSClientFactory.create();
        try {
            cc.deleteBucket(bucketName);
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    public static boolean doesBucketExist(String bucketName) throws CosClientException, CosServiceException {
        COSClient cc = COSClientFactory.create();
        boolean bucketExistFlag = cc.doesBucketExist(bucketName);
        return bucketExistFlag;
    }

    public static ObjectListing listObjects(String bucketName) throws CosClientException, CosServiceException {
        COSClient cc = COSClientFactory.create();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(bucketName);
        listObjectsRequest.setPrefix("");
        listObjectsRequest.setDelimiter("/");
        listObjectsRequest.setMarker("");
        listObjectsRequest.setMaxKeys(Integer.valueOf(100));
        ObjectListing objectListing = cc.listObjects(listObjectsRequest);
        String nextMarker = objectListing.getNextMarker();
        boolean isTruncated = objectListing.isTruncated();
        List objectSummaries = objectListing.getObjectSummaries();
        for (COSObjectSummary cosObjectSummary : objectSummaries) {
            String key = cosObjectSummary.getKey();
            long fileSize = cosObjectSummary.getSize();
            String eTag = cosObjectSummary.getETag();
            Date lastModified = cosObjectSummary.getLastModified();
            String string = cosObjectSummary.getStorageClass();
        }
        return objectListing;
    }

    public static String getBucketLocation(String bucketName) throws CosClientException, CosServiceException {
        COSClient cosClient = COSClientFactory.create();
        String location = cosClient.getBucketLocation(bucketName);
        return location;
    }

    public static String contentType(String FilenameExtension) {
        if (FilenameExtension.equals("BMP") || FilenameExtension.equals("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals("GIF") || FilenameExtension.equals("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equals("JPEG") || FilenameExtension.equals("jpeg") || FilenameExtension.equals("JPG") || FilenameExtension.equals("jpg") || FilenameExtension.equals("PNG") || FilenameExtension.equals("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals("HTML") || FilenameExtension.equals("html")) {
            return "text/html";
        }
        if (FilenameExtension.equals("TXT") || FilenameExtension.equals("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equals("VSD") || FilenameExtension.equals("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals("PPTX") || FilenameExtension.equals("pptx") || FilenameExtension.equals("PPT") || FilenameExtension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("DOCX") || FilenameExtension.equals("docx") || FilenameExtension.equals("DOC") || FilenameExtension.equals("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equals("XML") || FilenameExtension.equals("xml")) {
            return "text/xml";
        }
        return "text/html";
    }

    public static void main(String[] args) {
    }
}

