/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logistics.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.modules.logistics.entity.LogisticsCompanyItem;
import com.els.modules.logistics.service.ExpressBaidu;
import com.els.modules.logistics.service.ExpressTrace;
import com.els.modules.logistics.vo.LogisticsCompanyVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/trace"})
@CrossOrigin(value={"*"})
public class TraceController {
    @Autowired
    private ExpressTrace expressTrace;
    @Autowired
    private ExpressBaidu expressBaidu;

    @GetMapping(value={"/express"})
    public Result<?> selectExpress(@RequestParam(name="expressNumber") String expressNumber) throws Exception {
        if (!StringUtils.isEmpty((Object)expressNumber)) {
            if (expressNumber.contains("SF")) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_sf_findbyid", (String)"\u6682\u4e0d\u652f\u6301\u987a\u4e30\u7269\u6d41\u5355\u53f7\u67e5\u8be2"));
            }
            try {
                String newName = this.expressTrace.getExpressName(expressNumber);
                System.out.println(newName);
                if (StringUtils.isEmpty((Object)newName) || "auto".equals(newName)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_order_num_invalid", (String)"\u5355\u53f7\u65e0\u6548,\u67e5\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
                }
                String text = this.expressBaidu.getLatestMessage(newName, expressNumber);
                return Result.ok((Object)((Object)this.jsonResult(text)));
            }
            catch (JSONException | IOException e) {
                return Result.error((String)"\u67e5\u8be2\u5feb\u9012\u4fe1\u606f\u51fa\u9519!");
            }
        }
        return Result.error((String)"\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a!");
    }

    private LogisticsCompanyVO jsonResult(String json) {
        LogisticsCompanyVO logisticsCompanyVO = new LogisticsCompanyVO();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONObject info = jsonObject.getJSONObject("info");
        JSONArray context = info.getJSONArray("context");
        logisticsCompanyVO.setCurrent(info.getString("current"));
        logisticsCompanyVO.setCurrentStatus(info.getString("currentStatus"));
        logisticsCompanyVO.setLatestTime(info.getString("latest_time"));
        logisticsCompanyVO.setLatestProgress(info.getString("latest_progress"));
        JSONObject company = jsonObject.getJSONObject("company");
        logisticsCompanyVO.setCompanyName(company.getString("fullname"));
        logisticsCompanyVO.setCompanyNameIcon(company.getString("title_logo"));
        JSONObject kuaidiSource = jsonObject.getJSONObject("kuaidiSource");
        logisticsCompanyVO.setSourceCompany(kuaidiSource.getString("showName"));
        logisticsCompanyVO.setSourceCompanyIcon(kuaidiSource.getString("logo"));
        ArrayList<LogisticsCompanyItem> objects = new ArrayList<LogisticsCompanyItem>();
        context.forEach(item -> this.jsonToitem((JSONObject)item, objects));
        logisticsCompanyVO.setLogisticsCompanyItemList(objects);
        return logisticsCompanyVO;
    }

    private void jsonToitem(JSONObject jsonObject, List<LogisticsCompanyItem> objects) {
        LogisticsCompanyItem logisticsCompanyItem = new LogisticsCompanyItem();
        long time = jsonObject.getDate("time").getTime();
        logisticsCompanyItem.setAcceptTime(DateUtils.getDate((long)time));
        logisticsCompanyItem.setAcceptStation(jsonObject.getString("desc"));
        objects.add(logisticsCompanyItem);
    }
}

