/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.ElsBarCodeShortCode;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.mapper.ElsBarCodeShortCodeMapper;
import com.els.modules.barcode.service.ElsBarCodeShortCodeService;
import com.els.modules.barcode.vo.ShortCodeReqVO;
import com.els.modules.barcode.vo.ShortCodeRespVO;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ElsBarCodeShortCodeServiceImpl
extends BaseServiceImpl<ElsBarCodeShortCodeMapper, ElsBarCodeShortCode>
implements ElsBarCodeShortCodeService {
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    public void saveElsBarCodeShortCode(ElsBarCodeShortCode elsBarCodeShortCode) {
        elsBarCodeShortCode.setShortCodeNumber(this.codeGeneratorService.getNextCode("srmBarcodeShortCodeNumber", (Object)elsBarCodeShortCode));
        ((ElsBarCodeShortCodeMapper)this.baseMapper).insert((Object)elsBarCodeShortCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateElsBarCodeShortCode(ElsBarCodeShortCode elsBarCodeShortCode) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)elsBarCodeShortCode.getShortCodeType()), (Enum)I18nBarCodeEnum.SHORT_CODE_TYPE_IS_NULL);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)elsBarCodeShortCode.getOriginalValue()), (Enum)I18nBarCodeEnum.SHORT_CODE_ORIGINAL_VALUE_IS_NULL);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)elsBarCodeShortCode.getShortCodeValue()), (Enum)I18nBarCodeEnum.SHORT_CODE_SHORT_CODE_VALUE_IS_NULL);
        int countNum = ((ElsBarCodeShortCodeMapper)this.baseMapper).countTypeAndOriginalValue(elsBarCodeShortCode.getShortCodeType(), elsBarCodeShortCode.getOriginalValue(), TenantContext.getTenant(), elsBarCodeShortCode.getId());
        AssertI18nUtil.isTrue((countNum > 0 ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.SHORT_CODE_ORIGINAL_VALUE_IS_EXISTS);
        countNum = ((ElsBarCodeShortCodeMapper)this.baseMapper).countTypeAndShortValue(elsBarCodeShortCode.getShortCodeType(), elsBarCodeShortCode.getShortCodeValue(), TenantContext.getTenant(), elsBarCodeShortCode.getId());
        AssertI18nUtil.isTrue((countNum > 0 ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.SHORT_CODE_SHORT_CODE_VALUE_IS_EXISTS);
        int count = ((ElsBarCodeShortCodeMapper)this.baseMapper).updateById((Object)elsBarCodeShortCode);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delElsBarCodeShortCode(String id) {
        ((ElsBarCodeShortCodeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsBarCodeShortCode(List<String> idList) {
        ((ElsBarCodeShortCodeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<ShortCodeRespVO> getShortCodeValue(List<ShortCodeReqVO> shortCodeReqVOS) {
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(shortCodeReqVOS), (Enum)I18nBarCodeEnum.SHORT_CODE_DATA_NULL);
        List<ShortCodeRespVO> shortCodeRespVOS = shortCodeReqVOS.stream().map(shortCodeReqVO -> {
            String shortCodeValue = ((ElsBarCodeShortCodeMapper)this.baseMapper).getShortCodeValue(shortCodeReqVO.getOriginalValue(), shortCodeReqVO.getShortCodeType(), TenantContext.getTenant());
            return new ShortCodeRespVO(shortCodeReqVO.getOriginalValue(), shortCodeValue);
        }).collect(Collectors.toList());
        return shortCodeRespVOS;
    }
}

