/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.rocketMq.listener;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

@Component
public class InitI18nSitConsumer {
    private static final Logger log = LoggerFactory.getLogger(InitI18nSitConsumer.class);
    @Autowired
    private I18nService i18nService;

    @StreamListener(value="inputI18nSit")
    public void receive(String msgBody) {
        try {
            if (StringUtils.isBlank((CharSequence)msgBody)) {
                return;
            }
            JSONObject body = JSONObject.parseObject((String)msgBody);
            if (body.containsKey((Object)"i18nList")) {
                List collection = JSONObject.parseArray((String)body.getString("i18nList"), I18n.class);
                this.i18nService.saveMqMessage(collection);
            }
        }
        catch (Exception e) {
            log.error("InitI18nConsumer_receive_msgBody:" + msgBody, (Throwable)e);
            throw e;
        }
    }
}

