/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.barcode.entity.BarcodeSupplierList;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.enumerate.BarcodeResolveTypeEnum;
import com.els.modules.barcode.enumerate.PurchaseBarcodeInfoStatusEnum;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.service.BarcodeSupplierListService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoDetailService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoItemService;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodeInfoHeadService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="purchaseBarcodeInfoAdapter")
public class PurchaseBarcodeInfoAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseBarcodeInfoHeadService purchaseBarcodeInfoHeadService;
    @Autowired
    private PurchaseBarcodeInfoItemService purchaseBarcodeInfoItemService;
    @Autowired
    private PurchaseBarcodeInfoDetailService purchaseBarcodeInfoDetailService;
    @Autowired
    private BarcodeSupplierListService barcodeSupplierListService;
    @Autowired
    private SaleBarcodeInfoHeadService saleBarcodeInfoHeadService;
    @Autowired
    private ElsBarcodeRuleHeadMapper elsBarcodeRuleHeadMapper;
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    StaticConfig staticConfig;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseBarcodeInfoHead purchaseBarcodeInfohead = (PurchaseBarcodeInfoHead)((Object)JSONObject.parseObject((String)param, PurchaseBarcodeInfoHead.class));
        purchaseBarcodeInfohead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseBarcodeInfohead.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseBarcodeInfoHeadService.updateById((Object)purchaseBarcodeInfohead);
        this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.purchaseBarcodeInfoHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseBarcodeInfoHead.setId(inputParamVO.getBusinessId());
        purchaseBarcodeInfoHead.setAuditStatus(outputParamVO.getAuditStatus());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseBarcodeInfoHead.setInfoStatus(PurchaseBarcodeInfoStatusEnum.PUBLISH.getValue());
        }
        this.purchaseBarcodeInfoHeadService.updateById((Object)purchaseBarcodeInfoHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList = this.purchaseBarcodeInfoItemService.selectByMainId(inputParamVO.getBusinessId());
            List<PurchaseBarcodeInfoDetail> purchaseBarcodeInfoDetailList = this.purchaseBarcodeInfoDetailService.selectByMainId(inputParamVO.getBusinessId());
            List<PurchaseBarcodeInfoDetail> sysBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 1).collect(Collectors.toList());
            List<PurchaseBarcodeInfoDetail> customBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 2).collect(Collectors.toList());
            List<BarcodeSupplierList> barcodeSupplierListList = this.barcodeSupplierListService.selectByMainId(inputParamVO.getBusinessId());
            ElsBarcodeRuleHead ruleHead = (ElsBarcodeRuleHead)((Object)this.elsBarcodeRuleHeadMapper.selectById((Serializable)((Object)purchaseBarcodeInfoHead.getRuleId())));
            if (BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType())) {
                this.purchaseBarcodePoolHeadService.addByBarcodeInfo(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList);
            }
            this.saleBarcodeInfoHeadService.addByPurchase(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList, BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType()));
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.purchaseBarcodeInfoHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseBarcodeInfoHead.setId(inputParamVO.getBusinessId());
        purchaseBarcodeInfoHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseBarcodeInfoHeadService.updateById((Object)purchaseBarcodeInfoHead);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.purchaseBarcodeInfoHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseBarcodeInfoHead.setId(inputParamVO.getBusinessId());
        purchaseBarcodeInfoHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.purchaseBarcodeInfoHeadService.updateById((Object)purchaseBarcodeInfoHead);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"barcodeInfo", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"barcodeInfo", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.purchaseBarcodeInfoHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)purchaseBarcodeInfoHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        paramMap.put("serviceAddress", serviceAddress);
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        if (account.split("_").length > 2) {
            paramMap.put("taskId", account.split("_")[2]);
        }
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

