/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.util.I18nUtil;
import com.els.modules.system.service.ExcelItemExcelService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/base/excelByConfig"})
@Api(tags={"Excel\u914d\u7f6e"})
public class ExcelByConfigController {
    private static final Logger log = LoggerFactory.getLogger(ExcelByConfigController.class);
    @Autowired
    private ExcelItemExcelService service;

    @AutoLog(value="\u57fa\u4e8e\u914d\u7f6e\u5bfc\u5165\u5bfc\u51faExcel-\u4e0b\u8f7d\u6a21\u677f", operateType=6)
    @GetMapping(value={"/downloadTemplate"})
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response) {
        String headId = request.getParameter("id");
        String handlerName = request.getParameter("handlerName");
        String groupCode = request.getParameter("groupCode");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)handlerName, (String)I18nUtil.translate((String)"i18n_alert_empty_header_name", (String)"handlerName\u4e0d\u80fd\u4e3a\u7a7a"));
        String roleCode = request.getParameter("roleCode");
        this.service.download(response, headId, groupCode, handlerName, roleCode);
    }

    @AutoLog(value="\u57fa\u4e8e\u914d\u7f6e\u5bfc\u5165\u5bfc\u51faExcel-\u5bfc\u51fa", operateType=6)
    @GetMapping(value={"/exportExcel"})
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        String headId = request.getParameter("id");
        String handlerName = request.getParameter("handlerName");
        String groupCode = request.getParameter("groupCode");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)handlerName, (String)I18nUtil.translate((String)"i18n_alert_empty_header_name", (String)"handlerName\u4e0d\u80fd\u4e3a\u7a7a"));
        String roleCode = request.getParameter("roleCode");
        this.service.exportExcel(response, headId, groupCode, handlerName, roleCode);
    }

    @AutoLog(value="\u57fa\u4e8e\u914d\u7f6e\u5bfc\u5165\u5bfc\u51faExcel-\u5bfc\u5165", operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request) {
        String headId = request.getParameter("id");
        String handlerName = request.getParameter("handlerName");
        String groupCode = request.getParameter("groupCode");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)handlerName, (String)I18nUtil.translate((String)"i18n_alert_empty_header_name", (String)"handlerName\u4e0d\u80fd\u4e3a\u7a7a"));
        String roleCode = request.getParameter("roleCode");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        List<Object> data = new ArrayList();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            data = this.service.importExcel(headId, groupCode, handlerName, file, roleCode);
        }
        return Result.ok(data);
    }
}

