/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsCompanyBusinessRule;
import com.els.modules.system.mapper.ElsCompanyBusinessRuleMapper;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanyBusinessRuleService;
import com.els.modules.system.vo.DictModelVo;
import com.els.modules.system.vo.ElsCompanyBusinessRuleVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsCompanyBusinessRuleServiceImpl
extends ServiceImpl<ElsCompanyBusinessRuleMapper, ElsCompanyBusinessRule>
implements ElsCompanyBusinessRuleService {
    @Autowired
    private DictService dictService;

    @Override
    public List<ElsCompanyBusinessRuleVO> findByElsAccount(String elsAccount) {
        return ((ElsCompanyBusinessRuleMapper)this.baseMapper).findList(elsAccount);
    }

    @Override
    public List<DictModelVo> findList(String elsAccount) {
        List<ElsCompanyBusinessRuleVO> businessRuleList = ((ElsCompanyBusinessRuleMapper)this.baseMapper).findList(elsAccount);
        businessRuleList.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getItemDescI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemDesc())) {
                item.setItemDesc(I18nUtil.translate((String)item.getItemDescI18nKey(), (String)item.getItemDesc()));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getItemNameI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemName())) {
                item.setItemName(I18nUtil.translate((String)item.getItemNameI18nKey(), (String)item.getItemName()));
            }
        });
        List<DictModel> dictModelList = this.dictService.queryDictItemsByCode("srmBusinessType", elsAccount);
        ArrayList list = SysUtil.copyProperties(dictModelList, DictModelVo.class);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!"all".equals(((DictModelVo)it.next()).getValue())) continue;
            it.remove();
        }
        List<ElsCompanyBusinessRuleVO> ruleVOS = null;
        for (DictModelVo vo : list) {
            ruleVOS = businessRuleList.parallelStream().filter(o -> o.getBusinessType().equals(vo.getValue())).collect(Collectors.toList());
            vo.setBusinessSetList(ruleVOS);
        }
        return list;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String save(List<ElsCompanyBusinessRuleVO> list) {
        String message = null;
        String elsAccount = TenantContext.getTenant();
        ((ElsCompanyBusinessRuleMapper)this.baseMapper).deleteByAccount(elsAccount);
        ArrayList<ElsCompanyBusinessRule> companyBusinessRuleList = new ArrayList<ElsCompanyBusinessRule>();
        for (ElsCompanyBusinessRuleVO vo : list) {
            ElsCompanyBusinessRule companyBusinessRule = new ElsCompanyBusinessRule();
            BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)companyBusinessRule));
            companyBusinessRule.setId(null);
            companyBusinessRule.setSystemId(vo.getId());
            companyBusinessRule.setElsAccount(elsAccount);
            companyBusinessRule.setBusinessType(vo.getBusinessType());
            companyBusinessRuleList.add(companyBusinessRule);
        }
        if (!companyBusinessRuleList.isEmpty()) {
            this.saveBatch(companyBusinessRuleList);
        }
        return message;
    }
}

