/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.PurchaseAttachmentRecord;
import com.els.modules.attachment.oss.enumerate.AttachmentTypeEnum;
import com.els.modules.attachment.oss.service.IAttachmnetService;
import com.els.modules.attachment.service.PurchaseAttachmentRecordService;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.attachment.vo.PurchaseAttachmentVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u91c7\u8d2d\u9644\u4ef6"})
@RestController
@RequestMapping(value={"/attachment/purchaseAttachment"})
public class PurchaseAttachmentController
extends BaseController<PurchaseAttachment, PurchaseAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAttachmentController.class);
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private PurchaseAttachmentRecordService purchaseAttachmentRecordService;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String STR_FORMAT = "yyyyMMdd";
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";
    @Value(value="${file.server.type}")
    private String fileServerType;
    @Value(value="${els.config.service.address}")
    private String address;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseAttachment purchaseAttachment, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseAttachment), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.purchaseAttachmentService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        Assert.hasText((String)businessType, (String)I18nUtil.translate((String)"", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        String headId = request.getParameter("headId");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"", (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a"));
        String itemNumber = request.getParameter("itemNumber");
        String fileType = request.getParameter("fileType");
        String materialNumber = request.getParameter("materialNumber");
        String materialName = request.getParameter("materialName");
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        String elsAccount = this.getTenantId();
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay);
        if (!file.exists()) {
            file.mkdirs();
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                String documentType = "";
                String fileName = "";
                int suffixLocation = documentName.lastIndexOf(STR_DOT);
                if (suffixLocation > 0) {
                    documentType = documentName.substring(suffixLocation + 1);
                    fileName = documentName.substring(0, documentName.lastIndexOf(STR_DOT)) + STR_SPLIT + System.currentTimeMillis() + STR_DOT + documentType;
                } else {
                    fileName = documentName + STR_SPLIT + System.currentTimeMillis();
                }
                String documentLocation = File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay + File.separator + fileName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = file.getPath() + File.separator + fileName;
                IAttachmnetService iAttachmnetService = (IAttachmnetService)SpringContextUtils.getBean((String)AttachmentTypeEnum.getByType(this.fileServerType).getImplClass());
                iAttachmnetService.uploadFile(uploadFile, savePath);
                PurchaseAttachment attachment = new PurchaseAttachment();
                attachment.setBusinessType(businessType);
                attachment.setHeadId(headId);
                attachment.setItemNumber(itemNumber);
                attachment.setFileType(fileType);
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(elsAccount);
                attachment.setFileName(documentName);
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(documentLocation);
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                attachment.setMaterialName(materialName);
                attachment.setMaterialNumber(materialNumber);
                attachment.setSourceType("1");
                attachment.setSaveType(this.fileServerType);
                boolean result = this.purchaseAttachmentService.save((Object)attachment);
                if (!result) continue;
                return Result.ok((Object)((Object)attachment));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Result.error((String)"\u4e0a\u4f20\u5931\u8d25");
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
        String downloadFilePath = this.uploadpath + File.separator + attachment.getFilePath();
        if (downloadFilePath.contains("\\")) {
            downloadFilePath = downloadFilePath.replace("\\", "/");
        } else if (downloadFilePath.contains("//")) {
            downloadFilePath = downloadFilePath.replace("//", "/");
        }
        IAttachmnetService iAttachmnetService = (IAttachmnetService)SpringContextUtils.getBean((String)AttachmentTypeEnum.getByType(this.fileServerType).getImplClass());
        try {
            iAttachmnetService.downloadFile((OutputStream)response.getOutputStream(), downloadFilePath);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/noToken/download"})
    public void downloadNoToken(@RequestParam(name="id") String id, HttpServletResponse response) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
        String downloadFilePath = this.uploadpath + File.separator + attachment.getFilePath();
        if (downloadFilePath.contains("\\")) {
            downloadFilePath = downloadFilePath.replace("\\", "/");
        } else if (downloadFilePath.contains("//")) {
            downloadFilePath = downloadFilePath.replace("//", "/");
        }
        IAttachmnetService iAttachmnetService = (IAttachmnetService)SpringContextUtils.getBean((String)AttachmentTypeEnum.getByType(this.fileServerType).getImplClass());
        try {
            iAttachmnetService.downloadFile((OutputStream)response.getOutputStream(), downloadFilePath);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
        String elsAccount = TenantContext.getTenant();
        Assert.isTrue((boolean)elsAccount.equals(attachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"", (String)"\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        Assert.isTrue((boolean)"0".equals(attachment.getSendStatus()), (String)I18nUtil.translate((String)"", (String)"\u5df2\u53d1\u9001\u7684\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        IAttachmnetService iAttachmnetService = (IAttachmnetService)SpringContextUtils.getBean((String)AttachmentTypeEnum.getByType(this.fileServerType).getImplClass());
        iAttachmnetService.delete(attachment.getFilePath());
        this.purchaseAttachmentService.delPurchaseAttachment(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List purchaseAttachmentList;
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(purchaseAttachmentList = this.purchaseAttachmentService.listByIds(idList)))) {
            for (PurchaseAttachment purchaseAttachment : purchaseAttachmentList) {
                filePaths.add(purchaseAttachment.getFilePath());
            }
        }
        IAttachmnetService iAttachmnetService = (IAttachmnetService)SpringContextUtils.getBean((String)AttachmentTypeEnum.getByType(this.fileServerType).getImplClass());
        iAttachmnetService.deleteBatch(filePaths);
        this.purchaseAttachmentService.delBatchPurchaseAttachment(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseAttachment attachmentBuy = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
        List<PurchaseAttachmentRecord> purchaseAttachmentRecordList = this.purchaseAttachmentRecordService.selectByMainId(id);
        PurchaseAttachmentVO attachmentVO = new PurchaseAttachmentVO();
        BeanUtil.copyProperties((Object)((Object)attachmentBuy), (Object)((Object)attachmentVO), (String[])new String[0]);
        attachmentVO.setPurchaseAttachmentRecordList(purchaseAttachmentRecordList);
        return Result.ok((Object)((Object)attachmentVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u9644\u4ef6\u53d1\u9001", operateType=3)
    @ApiOperation(value="\u9644\u4ef6\u53d1\u9001", notes="\u9644\u4ef6\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody AttachmentSendVO sendVO) {
        this.purchaseAttachmentService.sendFile(sendVO);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u7684\u9884\u89c8\u94fe\u63a5", notes="\u83b7\u53d6\u6587\u4ef6\u7684\u9884\u89c8\u94fe\u63a5")
    @GetMapping(value={"/getSignature"})
    public Result<?> getSignature(PurchaseAttachment purchaseAttachment, HttpServletRequest request) {
        String signature = this.purchaseAttachmentService.getSignature(purchaseAttachment.getSaveType(), purchaseAttachment.getFilePath(), this.address + "/opt/upFiles");
        return Result.ok((String)signature);
    }
}

