/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.BarcodeTemplateSupplierList;
import com.els.modules.barcode.entity.PurchaseBarcodeTemplateHead;
import com.els.modules.barcode.entity.PurchaseBarcodeTemplateItem;
import com.els.modules.barcode.entity.SaleBarcodeTemplateHead;
import com.els.modules.barcode.entity.SaleBarcodeTemplateItem;
import com.els.modules.barcode.mapper.SaleBarcodeTemplateHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodeTemplateItemMapper;
import com.els.modules.barcode.service.SaleBarcodeTemplateHeadService;
import com.els.modules.barcode.service.SaleBarcodeTemplateItemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleBarcodeTemplateHeadServiceImpl
extends BaseServiceImpl<SaleBarcodeTemplateHeadMapper, SaleBarcodeTemplateHead>
implements SaleBarcodeTemplateHeadService {
    @Autowired
    private SaleBarcodeTemplateHeadMapper saleBarcodeTemplateHeadMapper;
    @Autowired
    private SaleBarcodeTemplateItemMapper saleBarcodeTemplateItemMapper;
    @Autowired
    private SaleBarcodeTemplateItemService saleBarcodeTemplateItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleBarcodeTemplateHead saleBarcodeTemplateHead, List<SaleBarcodeTemplateItem> saleBarcodeTemplateItemList) {
        this.saleBarcodeTemplateHeadMapper.insert((Object)saleBarcodeTemplateHead);
        this.insertData(saleBarcodeTemplateHead, saleBarcodeTemplateItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleBarcodeTemplateHead saleBarcodeTemplateHead, List<SaleBarcodeTemplateItem> saleBarcodeTemplateItemList) {
        int count = this.saleBarcodeTemplateHeadMapper.updateById((Object)saleBarcodeTemplateHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.saleBarcodeTemplateItemMapper.deleteByMainId(saleBarcodeTemplateHead.getId());
        this.insertData(saleBarcodeTemplateHead, saleBarcodeTemplateItemList);
    }

    private void insertData(SaleBarcodeTemplateHead saleBarcodeTemplateHead, List<SaleBarcodeTemplateItem> saleBarcodeTemplateItemList) {
        if (saleBarcodeTemplateItemList != null && !saleBarcodeTemplateItemList.isEmpty()) {
            for (SaleBarcodeTemplateItem entity : saleBarcodeTemplateItemList) {
                entity.setHeadId(saleBarcodeTemplateHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleBarcodeTemplateHead);
            }
            this.saleBarcodeTemplateItemService.saveBatch(saleBarcodeTemplateItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleBarcodeTemplateItemMapper.deleteByMainId(id);
        this.saleBarcodeTemplateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleBarcodeTemplateItemMapper.deleteByMainId(serializable.toString());
            this.saleBarcodeTemplateHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void addByPurchase(PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead, List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList, List<BarcodeTemplateSupplierList> barcodeTemplateSupplierList) {
        for (BarcodeTemplateSupplierList barcodeTemplateSupplier : barcodeTemplateSupplierList) {
            SaleBarcodeTemplateHead saleBarcodeTemplateHead = new SaleBarcodeTemplateHead();
            BeanUtils.copyProperties((Object)((Object)purchaseBarcodeTemplateHead), (Object)((Object)saleBarcodeTemplateHead));
            saleBarcodeTemplateHead.setId(null);
            saleBarcodeTemplateHead.setRelationId(purchaseBarcodeTemplateHead.getId());
            saleBarcodeTemplateHead.setElsAccount(barcodeTemplateSupplier.getToElsAccount());
            saleBarcodeTemplateHead.setToElsAccount(barcodeTemplateSupplier.getElsAccount());
            saleBarcodeTemplateHead.setSupplierCode(barcodeTemplateSupplier.getSupplierCode());
            saleBarcodeTemplateHead.setSupplierName(barcodeTemplateSupplier.getSupplierName());
            this.saleBarcodeTemplateHeadMapper.insert((Object)saleBarcodeTemplateHead);
            ArrayList<SaleBarcodeTemplateItem> saleBarcodeTemplateItemList = new ArrayList<SaleBarcodeTemplateItem>();
            for (PurchaseBarcodeTemplateItem purchaseBarcodeTemplateItem : purchaseBarcodeTemplateItemList) {
                SaleBarcodeTemplateItem saleBarcodeTemplateItem = new SaleBarcodeTemplateItem();
                BeanUtils.copyProperties((Object)((Object)purchaseBarcodeTemplateItem), (Object)((Object)saleBarcodeTemplateItem));
                saleBarcodeTemplateItem.setId(null);
                saleBarcodeTemplateItem.setRelationId(purchaseBarcodeTemplateItem.getId());
                saleBarcodeTemplateItem.setElsAccount(barcodeTemplateSupplier.getToElsAccount());
                saleBarcodeTemplateItem.setHeadId(saleBarcodeTemplateHead.getId());
                saleBarcodeTemplateItemList.add(saleBarcodeTemplateItem);
            }
            this.saleBarcodeTemplateItemService.saveBatch(saleBarcodeTemplateItemList);
        }
    }
}

