/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.storage.enumerate.StorageTypeEnum;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6587\u4ef6\u5b58\u50a8\u7b7e\u540d"})
@RestController
@RequestMapping(value={"/attachment/store"})
public class StorageController {
    private static final Logger log = LoggerFactory.getLogger(StorageController.class);
    @Value(value="${els.storage.type}")
    private String storeType;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @GetMapping(value={"/noToken/callbackServer"})
    public void callbackServerGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info("\u7528\u6237\u8f93\u5165url:{}", (Object)request.getRequestURI());
        this.response(request, response, "input get ", 200);
    }

    @PostMapping(value={"/noToken/callbackServer"})
    public void verifyCallbackRequest(HttpServletRequest request, HttpServletResponse response) {
        this.fileStoreSignServiceImpl.verifyCallbackRequest(request, response, this.storeType);
    }

    @GetMapping(value={"/policySign"})
    public void policySign(HttpServletRequest request, HttpServletResponse response, Map<String, Object> param) throws IOException {
        JSONObject result;
        if (StorageTypeEnum.OSS.getCode().equals(this.storeType)) {
            param.put("dir", TenantContext.getTenant());
            param.put("expireTime", null);
            param.put("saveType", "2");
        }
        if (null == (result = this.fileStoreSignServiceImpl.sign(JSONObject.parseObject((String)JSON.toJSONString(param)), true, this.storeType))) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u4e0a\u4f20\u7b7e\u540d\u5931\u8d25"));
        }
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST");
        this.response(request, response, result.toJSONString());
    }

    @Deprecated
    private void response(HttpServletRequest request, HttpServletResponse response, String results, Integer status) throws IOException {
        String callbackFunName = request.getParameter("callback");
        response.addHeader("Content-Length", String.valueOf(results.length()));
        if (callbackFunName == null || "".equalsIgnoreCase(callbackFunName)) {
            response.getWriter().println(results);
        } else {
            response.getWriter().println(callbackFunName + "( " + results + " )");
        }
        response.setStatus(status.intValue());
        response.flushBuffer();
    }

    @Deprecated
    private void response(HttpServletRequest request, HttpServletResponse response, String results) throws IOException {
        String callbackFunName = request.getParameter("callback");
        if (callbackFunName == null || "".equalsIgnoreCase(callbackFunName)) {
            response.getWriter().println(results);
        } else {
            response.getWriter().println(callbackFunName + "( " + results + " )");
        }
        response.setStatus(200);
        response.flushBuffer();
    }
}

