/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.storage.enumerate.StorageTypeEnum;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.attachment.storage.spi.StorageSpi;
import java.util.ServiceLoader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fileStoreSignServiceImpl")
public class FileStoreSignServiceImpl
implements FileStoreSignService {
    private static final Logger log = LoggerFactory.getLogger(FileStoreSignServiceImpl.class);

    protected StorageSpi getClientService(String type) {
        ServiceLoader<StorageSpi> spis = ServiceLoader.load(StorageSpi.class);
        for (StorageSpi spi : spis) {
            if (!spi.type().equals(type)) continue;
            return spi;
        }
        log.error(":::\u6ca1\u6709\u53ef\u7528\u7684\u7b2c\u4e09\u65b9\u6587\u4ef6\u5b58\u50a8\u670d\u52a1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e...[{}]", (Object)type);
        return null;
    }

    @Override
    public JSONObject sign(JSONObject policyParam, boolean callBack, String type) {
        if (StorageTypeEnum.LOCAL.getCode().equals(type)) {
            JSONObject result = new JSONObject();
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u4e0d\u652f\u6301\u83b7\u53d6\u7b7e\u540d...", (Object)type);
            result.put("supportSign", (Object)false);
            return result;
        }
        StorageSpi clientService = this.getClientService(type);
        if (null == clientService) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6ca1\u6709\u53ef\u7528\u7684\u7b2c\u4e09\u65b9\u6587\u4ef6\u5b58\u50a8\u670d\u52a1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e"));
        }
        if (!clientService.supportSign()) {
            JSONObject result = new JSONObject();
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u4e0d\u652f\u6301\u83b7\u53d6\u7b7e\u540d...", (Object)type);
            result.put("supportSign", (Object)false);
            return result;
        }
        JSONObject result = callBack ? this.getClientService(type).getPolicyAndCallback(policyParam) : this.getClientService(type).getPolicy(policyParam);
        if (null == result) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u7b7e\u540d\u5931\u8d25"));
        }
        result.put("supportSign", (Object)true);
        return result;
    }

    @Override
    public String getDownloadPath(String objectPath, Boolean expire, String type) {
        return this.getClientService(type).getDownloadPath(objectPath, expire);
    }

    @Override
    public void verifyCallbackRequest(HttpServletRequest request, HttpServletResponse response, String type) {
        StorageSpi clientService = this.getClientService(type);
        if (null == clientService) {
            log.error(":::\u6ca1\u6709\u53ef\u7528\u7684\u7b2c\u4e09\u65b9\u6587\u4ef6\u5b58\u50a8\u670d\u52a1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e...");
            return;
        }
        if (!clientService.supportCallBack() && !clientService.getStoreProperties().supportSign(type)) {
            log.error(":::\u5f53\u524d\u5b58\u50a8\u65b9\u5f0f\u4e0d\u652f\u6301\u56de\u8c03\u6821\u9a8c:{}", (Object)type);
            return;
        }
        clientService.verifyCallbackRequest(request, response);
    }
}

