/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.storage.config.StorageProperties;
import com.els.modules.attachment.storage.enumerate.StorageTypeEnum;
import com.els.modules.attachment.storage.spi.StorageSpi;
import com.els.modules.attachment.storage.vo.CallBackFileVo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssStorageClient
implements StorageSpi {
    private static final Logger log = LoggerFactory.getLogger(OssStorageClient.class);

    public OSSClient loadStorageClient() {
        return (OSSClient)SpringContextUtils.getBean((String)"defaultOssClient");
    }

    @Override
    public String type() {
        return StorageTypeEnum.OSS.getCode();
    }

    @Override
    public JSONObject getPolicy(JSONObject policyParam) {
        String dir = policyParam.getString("dir");
        if (StrUtil.isNotEmpty((CharSequence)dir) && !dir.endsWith("/")) {
            dir = dir + "/";
        }
        Integer expireTime = policyParam.getInteger("expireTime");
        String saveType = policyParam.getString("saveType");
        OSSClient ossClient = this.loadStorageClient();
        StorageProperties storeProperties = this.getStoreProperties();
        JSONObject result = null;
        long expireTimez = 0L;
        String num = "2";
        try {
            long l120 = 120L;
            expireTimez = expireTime != null && (long)expireTime.intValue() <= l120 ? (long)expireTime.intValue() * 60L : (long)storeProperties.getOss().getExpireTime().intValue() * 60L;
            long expireEndTime = System.currentTimeMillis() + expireTimez * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = ossClient.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = ossClient.calculatePostSignature(postPolicy);
            result = new JSONObject();
            result.put("accessid", (Object)storeProperties.getOss().getAccessKeyId());
            result.put("policy", (Object)encodedPolicy);
            result.put("signature", (Object)postSignature);
            result.put("dir", (Object)(StrUtil.isBlank((CharSequence)dir) ? storeProperties.getOss().getDir() : dir));
            if (num.equals(saveType)) {
                result.put("host", (Object)storeProperties.getOss().getPublicHost());
            } else {
                result.put("host", (Object)storeProperties.getOss().getPrivateHost());
            }
            result.put("expire", (Object)String.valueOf(expireEndTime / 1000L));
        }
        catch (Exception e) {
            log.error(":::OSS\u83b7\u53d6\u7b7e\u540d\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
        return result;
    }

    @Override
    public JSONObject getPolicyAndCallback(JSONObject policyParam) {
        JSONObject respMap;
        try {
            respMap = this.getPolicy(policyParam);
            StorageProperties storeProperties = this.getStoreProperties();
            JSONObject jasonCallback = new JSONObject();
            jasonCallback.put("callbackUrl", (Object)storeProperties.getOss().getCallBackConfig().getCallbackUrl());
            jasonCallback.put("callbackBody", (Object)storeProperties.getOss().getCallBackConfig().getCallbackBody());
            jasonCallback.put("callbackBodyType", (Object)storeProperties.getOss().getCallBackConfig().getCallbackBodyType());
            String callback = BinaryUtil.toBase64String((byte[])jasonCallback.toString().getBytes());
            respMap.put("callback", (Object)callback);
        }
        catch (Exception e) {
            log.error(":::OSS\u83b7\u53d6\u7b7e\u540d\u548c\u56de\u8c03\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
        return respMap;
    }

    @Override
    public String getDownloadPath(String objectPath, Boolean expire) {
        URL url;
        String stringHttp = "http:";
        if (BooleanUtil.isTrue((Boolean)expire)) {
            DateTime expiration = DateUtil.date((long)(System.currentTimeMillis() + (long)(this.getStoreProperties().getOss().getExpireTime() * 1000)));
            url = this.loadStorageClient().generatePresignedUrl(this.getStoreProperties().getOss().getBucketName(), objectPath, (Date)expiration);
        } else {
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.getStoreProperties().getOss().getBucketName(), objectPath);
            request.setMethod(HttpMethod.GET);
            url = this.loadStorageClient().generatePresignedUrl(request);
        }
        String urlStr = url.toString();
        if (urlStr.indexOf(stringHttp) == 0) {
            urlStr = urlStr.replace("http:", "https:");
        }
        return urlStr;
    }

    @Override
    public void verifyCallbackRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            String ossCallbackBody = this.getPostBody((InputStream)request.getInputStream(), Integer.parseInt(request.getHeader("content-length")));
            if (this.getStoreProperties().getOss().isSignCheck()) {
                boolean ret = this.verifyCallbackRequest(request, ossCallbackBody);
                log.info("verify result:{}", (Object)ret);
                if (ret) {
                    this.response(request, response, "{\"Status\":\"OK\"}", 200);
                } else {
                    this.response(request, response, "{\"Status\":\"verdify not ok\"}", 400);
                }
            }
            Map parameterMap = request.getParameterMap();
            CallBackFileVo callBackFileVo = new CallBackFileVo();
            callBackFileVo.setFileSize(((String[])parameterMap.get("size"))[0]);
            callBackFileVo.setFileName(((String[])parameterMap.get("filename"))[0]);
            callBackFileVo.setFileSize(((String[])parameterMap.get("mimeType"))[0]);
            callBackFileVo.setFilePath(this.getDownloadPath(callBackFileVo.getFileName(), true));
            log.info("OSS Callback Body:{}", (Object)ossCallbackBody);
            this.response(request, response, JSON.toJSONString((Object)callBackFileVo), 200);
        }
        catch (Exception e) {
            log.error(":::Oss\u6587\u4ef6\u5b58\u50a8\u56de\u8c03\u6821\u9a8c\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    protected boolean verifyCallbackRequest(HttpServletRequest request, String ossCallbackBody) throws NumberFormatException, IOException {
        boolean ret = false;
        String autorizationInput = request.getHeader("Authorization");
        String pubKeyInput = request.getHeader("x-oss-pub-key-url");
        byte[] authorization = BinaryUtil.fromBase64String((String)autorizationInput);
        byte[] pubKey = BinaryUtil.fromBase64String((String)pubKeyInput);
        String pubKeyAddr = new String(pubKey);
        if (!pubKeyAddr.startsWith("http://gosspublic.alicdn.com/") && !pubKeyAddr.startsWith("https://gosspublic.alicdn.com/")) {
            log.info("pub key addr must be oss addrss");
            return false;
        }
        String retString = this.executeGet(pubKeyAddr);
        retString = retString.replace("-----BEGIN PUBLIC KEY-----", "");
        retString = retString.replace("-----END PUBLIC KEY-----", "");
        String queryString = request.getQueryString();
        String uri = request.getRequestURI();
        String decodeUri = URLDecoder.decode(uri, "UTF-8");
        if (queryString != null && !"".equals(queryString)) {
            decodeUri = decodeUri + "?" + queryString;
        }
        decodeUri = decodeUri + "\n" + ossCallbackBody;
        ret = this.doCheck(decodeUri, authorization, retString);
        return ret;
    }

    public boolean doCheck(String content, byte[] sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = BinaryUtil.fromBase64String((String)publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(pubKey);
            signature.update(content.getBytes());
            return signature.verify(sign);
        }
        catch (Exception e) {
            log.error(":::OssStorageClient verifyCallbackRequest {}", (Object)e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url) {
        BufferedReader in = null;
        DefaultHttpClient client = null;
        String content = null;
        try {
            client = new DefaultHttpClient();
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String nl = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + nl);
            }
            in.close();
            content = sb.toString();
        }
        catch (Exception e) {
            log.error(":::OssStorageClient executeGet url:{},error:{}", (Object)url, (Object)e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception e) {
                log.error(":::OssStorageClient executeGet url:{},error:{}", (Object)url, (Object)e.getMessage());
            }
        }
        return content;
    }

    public String getPostBody(InputStream is, int contentLen) {
        if (contentLen > 0) {
            int readLengthThisTime = 0;
            byte[] message = new byte[contentLen];
            try {
                for (int readLen = 0; readLen != contentLen && (readLengthThisTime = is.read(message, readLen, contentLen - readLen)) != -1; readLen += readLengthThisTime) {
                }
                return new String(message);
            }
            catch (IOException e) {
                log.error(":::Oss\u6587\u4ef6\u5b58\u50a8\u56de\u8c03\u83b7\u53d6\u8bf7\u6c42\u4f53\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        return "";
    }

    public Map<String, String> getSTS(String sessionName, String edir) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StorageProperties storeProperties = this.getStoreProperties();
            DefaultProfile profile = DefaultProfile.getProfile((String)storeProperties.getOss().getStsRegion(), (String)storeProperties.getOss().getAccessKeyId(), (String)storeProperties.getOss().getAccessKeySecret());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            ProtocolType protocolType = ProtocolType.HTTPS;
            String policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:Get*\", \n                \"oss:List*\" \n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:" + storeProperties.getOss().getBucketName() + "/" + edir + "/*\"\n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setVersion(storeProperties.getOss().getStsServion());
            request.setMethod(MethodType.POST);
            request.setProtocol(protocolType);
            request.setRoleArn(storeProperties.getOss().getStsRoleArn());
            request.setRoleSessionName(sessionName);
            request.setPolicy(policy);
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            map.put("Expiration", response.getCredentials().getExpiration());
            map.put("AccessKeyId", response.getCredentials().getAccessKeyId());
            map.put("AccessKeySecret", response.getCredentials().getAccessKeySecret());
            map.put("Token", response.getCredentials().getSecurityToken());
        }
        catch (Exception e) {
            log.error(":::OSS GetSts error:{}", (Object)e.getMessage());
            return null;
        }
        return map;
    }
}

