/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.modules.api.service.FinanceByIntegratedApiService;
import com.els.modules.api.service.InquiryByIntegratedApiService;
import com.els.modules.api.service.OrderByIntegratedApiService;
import com.els.modules.bidding.api.dto.PurchaseBiddingHeadDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.service.PurchaseContractHeadRpcService;
import com.els.modules.delivery.api.dto.PurchaseDeliveryHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseDeliveryNoticeDTO;
import com.els.modules.delivery.api.dto.PurchaseRefundsDeliveryHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherHeadDTO;
import com.els.modules.demand.api.dto.PurchaseRequestHeadDTO;
import com.els.modules.ebidding.api.dto.PurchaseEbiddingHeadDTO;
import com.els.modules.finance.api.dto.PurchaseAddCostDTO;
import com.els.modules.finance.api.dto.PurchaseDeductCostDTO;
import com.els.modules.finance.api.dto.PurchasePaymentApplyHeadDTO;
import com.els.modules.inquiry.api.dto.PurchaseEnquiryHeadDTO;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.integrated.entity.IntegratedDocument;
import com.els.modules.integrated.entity.IntegratedDocumentOutDTO;
import com.els.modules.integrated.enumerate.IntegratedDocumentEnum;
import com.els.modules.integrated.mapper.IntegratedDocumentMapper;
import com.els.modules.integrated.service.IntegratedDocumentService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.service.PurchaseOrderHeadRpcService;
import com.els.modules.order.api.service.PurchaseOrderItemRpcService;
import com.els.modules.reconciliation.api.dto.PurchaseInvoiceDTO;
import com.els.modules.reconciliation.api.dto.PurchaseReconciliationDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegratedDocumentServiceImpl
extends BaseServiceImpl<IntegratedDocumentMapper, IntegratedDocument>
implements IntegratedDocumentService {
    @Resource
    private IntegratedDocumentMapper integratedDocumentMapper;
    @Resource
    @Lazy
    private InquiryByIntegratedApiService inquiryByIntegratedApiService;
    @Resource
    @Lazy
    private PurchaseContractHeadRpcService purchaseContractHeadRpcService;
    @Resource
    @Lazy
    private OrderByIntegratedApiService orderByIntegratedApiService;
    @Resource
    @Lazy
    private FinanceByIntegratedApiService financeByIntegratedApiService;
    @Resource
    @Lazy
    private PurchaseOrderHeadRpcService purchaseOrderHeadRpcService;
    @Resource
    @Lazy
    private PurchaseOrderItemRpcService purchaseOrderItemRpcService;
    private static Object rootId = null;

    @Override
    public Map<String, Object> getDetail(IntegratedDocumentDTO integratedDocumentDTO) {
        IntegratedDocument integratedDocument = new IntegratedDocument();
        BeanUtils.copyProperties((Object)integratedDocumentDTO, (Object)integratedDocument);
        IntegratedDocument document = this.integratedDocumentMapper.selectById(integratedDocument.getId());
        Assert.isNotNull((Object)document, (String)"\u6682\u65e0\u53ef\u67e5\u770b\u7684\u5355\u636e\u8054\u67e5\u4fe1\u606f");
        Assert.isNotNull((Object)document.getLinks(), (String)"\u6682\u65e0\u53ef\u67e5\u770b\u7684\u5355\u636e\u8054\u67e5\u4fe1\u606f");
        ArrayList<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        JSONArray jsonLinks = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)document.getBetweenId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(IntegratedDocument::getBetweenId, (Object)document.getBetweenId());
            List integratedDocumentList = this.integratedDocumentMapper.selectList((Wrapper)queryWrapper);
            integratedDocumentList.forEach(tempDocument -> {
                IntegratedDocumentOutDTO outDTO = new IntegratedDocumentOutDTO();
                BeanUtils.copyProperties((Object)tempDocument, (Object)outDTO);
                Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)outDTO), Map.class);
                this.getNodes(map, integratedDocument, nodeList, tempList);
                jsonLinks.addAll((Collection)JSONObject.parseArray((String)tempDocument.getLinks().toString()));
                rootId = map.get(IntegratedDocumentEnum.PAYMENT_APPLY_HEAD_ID.getValue());
            });
        } else {
            IntegratedDocumentOutDTO outDTO = new IntegratedDocumentOutDTO();
            BeanUtils.copyProperties((Object)document, (Object)outDTO);
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)outDTO), Map.class);
            this.getNodes(map, integratedDocument, nodeList, tempList);
            jsonLinks.addAll((Collection)JSONObject.parseArray((String)document.getLinks().toString()));
            rootId = map.containsKey(IntegratedDocumentEnum.REQUEST_HEAD_ID.getValue()) ? map.get(IntegratedDocumentEnum.REQUEST_HEAD_ID.getValue()) : map.get(IntegratedDocumentEnum.ORDER_HEAD_ID.getValue());
        }
        nodeList.addAll(tempList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rootId", rootId);
        data.put("nodes", nodeList);
        data.put("links", jsonLinks);
        return data;
    }

    @Override
    public void updateMain(String type, String id, String parentId, String childId) {
        IntegratedDocument documentPage = new IntegratedDocument();
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        IntegratedDocument dbDocument = this.integratedDocumentMapper.selectById(id);
        if (dbDocument == null) {
            String uuid = UUID.randomUUID().toString();
            documentPage.setId(uuid);
            this.setSourceId(type, childId, documentPage);
            this.integratedDocumentMapper.insert(documentPage);
            this.setIntergratedDocumentId(type, uuid, childId);
        } else {
            documentPage.setId(id);
            this.setSourceId(type, childId, documentPage);
            json.put("from", (Object)parentId);
            json.put("to", (Object)childId);
            if (dbDocument.getLinks() != null) {
                array = JSONObject.parseArray((String)dbDocument.getLinks().toString());
            }
            array.add((Object)json);
            documentPage.setLinks(array.toString());
            this.checkDatas(dbDocument, documentPage);
            this.integratedDocumentMapper.updateById(documentPage);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String type, String id, String parentId, String childId) {
        IntegratedDocument document = this.integratedDocumentMapper.selectById(id);
        if (document != null) {
            this.delNode(type, childId, document);
            if (document.getLinks() != null) {
                JSONArray array = JSONObject.parseArray((String)document.getLinks().toString());
                Iterator it = array.iterator();
                while (it.hasNext()) {
                    JSONObject jsonLink = JSONObject.parseObject((String)it.next().toString());
                    if (!jsonLink.get((Object)"from").equals(parentId) || !jsonLink.get((Object)"to").equals(childId)) continue;
                    it.remove();
                }
                document.setLinks(array.size() > 0 ? array.toString() : null);
                this.integratedDocumentMapper.updateById(document);
            }
        }
    }

    private void checkDatas(IntegratedDocument document, IntegratedDocument documentPage) {
        if (StringUtils.isNotBlank((CharSequence)document.getInqueryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getInqueryHeadId())) {
            documentPage.setInqueryHeadId(document.getInqueryHeadId() + "," + documentPage.getInqueryHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getEbiddingHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getEbiddingHeadId())) {
            documentPage.setEbiddingHeadId(document.getEbiddingHeadId() + "," + documentPage.getEbiddingHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getBiddingHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getBiddingHeadId())) {
            documentPage.setBiddingHeadId(document.getBiddingHeadId() + "," + documentPage.getBiddingHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getOrderHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getOrderHeadId())) {
            documentPage.setOrderHeadId(document.getOrderHeadId() + "," + documentPage.getOrderHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getContractHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getContractHeadId())) {
            documentPage.setContractHeadId(document.getContractHeadId() + "," + documentPage.getContractHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getSaleDeliveryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getSaleDeliveryHeadId())) {
            documentPage.setSaleDeliveryHeadId(document.getSaleDeliveryHeadId() + "," + documentPage.getSaleDeliveryHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getPurchaseDeliveryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getPurchaseDeliveryHeadId())) {
            documentPage.setPurchaseDeliveryHeadId(document.getPurchaseDeliveryHeadId() + "," + documentPage.getPurchaseDeliveryHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getRefundsDeliveryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getRefundsDeliveryHeadId())) {
            documentPage.setRefundsDeliveryHeadId(document.getRefundsDeliveryHeadId() + "," + documentPage.getRefundsDeliveryHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getVoucherHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getVoucherHeadId())) {
            documentPage.setVoucherHeadId(document.getVoucherHeadId() + "," + documentPage.getVoucherHeadId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getReconciliationId()) && StringUtils.isNotBlank((CharSequence)documentPage.getReconciliationId())) {
            documentPage.setReconciliationId(document.getReconciliationId() + "," + documentPage.getReconciliationId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getAddCostId()) && StringUtils.isNotBlank((CharSequence)documentPage.getAddCostId())) {
            documentPage.setAddCostId(document.getAddCostId() + "," + documentPage.getAddCostId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getDeductCostId()) && StringUtils.isNotBlank((CharSequence)documentPage.getDeductCostId())) {
            documentPage.setDeductCostId(document.getDeductCostId() + "," + documentPage.getDeductCostId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getInvoiceId()) && StringUtils.isNotBlank((CharSequence)documentPage.getInvoiceId())) {
            documentPage.setInvoiceId(document.getInvoiceId() + "," + documentPage.getInvoiceId());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getPaymentApplyHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getPaymentApplyHeadId())) {
            documentPage.setPaymentApplyHeadId(document.getPaymentApplyHeadId() + "," + documentPage.getPaymentApplyHeadId());
        }
    }

    private String getSourceNumber(String key, String value) {
        String sourceNumber = null;
        switch (key) {
            case "requestHeadId": {
                PurchaseRequestHeadDTO purchaseRequestHead = this.inquiryByIntegratedApiService.getRequestHeadById(value);
                sourceNumber = purchaseRequestHead.getRequestNumber();
                break;
            }
            case "inqueryHeadId": {
                PurchaseEnquiryHeadDTO purchaseEnquiryHead = this.inquiryByIntegratedApiService.getEnquiryHeadById(value);
                sourceNumber = purchaseEnquiryHead.getEnquiryNumber();
                break;
            }
            case "ebiddingHeadId": {
                PurchaseEbiddingHeadDTO purchaseEbiddingHead = this.inquiryByIntegratedApiService.getEbinddingHeadById(value);
                sourceNumber = purchaseEbiddingHead.getEbiddingNumber();
                break;
            }
            case "biddingHeadId": {
                PurchaseBiddingHeadDTO purchaseBiddingHead = this.inquiryByIntegratedApiService.getBiddingHeadById(value);
                sourceNumber = purchaseBiddingHead.getBiddingNumber();
                break;
            }
            case "contractHeadId": {
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.purchaseContractHeadRpcService.getById(value);
                sourceNumber = purchaseContractHeadDTO.getContractNumber();
                break;
            }
            case "orderHeadId": {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.orderByIntegratedApiService.getOrderHeadById(value);
                sourceNumber = purchaseOrderHeadDTO.getOrderNumber();
                break;
            }
            case "deliveryNoticeId": {
                PurchaseDeliveryNoticeDTO purchaseDeliveryNotice = this.orderByIntegratedApiService.getDeliveryNoticeById(value);
                sourceNumber = purchaseDeliveryNotice.getNoticeNumber();
                break;
            }
            case "purchaseDeliveryHeadId": {
                PurchaseDeliveryHeadDTO purchaseDeliveryHead = this.orderByIntegratedApiService.getDeliveryHeadById(value);
                sourceNumber = purchaseDeliveryHead.getDeliveryNumber();
                break;
            }
            case "refundsDeliveryHeadId": {
                PurchaseRefundsDeliveryHeadDTO purchaseRefundsDeliveryHead = this.orderByIntegratedApiService.getRefundsDeliveryHeadById(value);
                sourceNumber = purchaseRefundsDeliveryHead.getRefundsDeliveryNumber();
                break;
            }
            case "voucherHeadId": {
                PurchaseVoucherHeadDTO purchaseVoucherHead = this.orderByIntegratedApiService.getVoucherHeadById(value);
                sourceNumber = purchaseVoucherHead.getVoucherNumber();
                break;
            }
            case "reconciliationId": {
                PurchaseReconciliationDTO purchaseReconciliation = this.financeByIntegratedApiService.getReconciliationHeadById(value);
                sourceNumber = purchaseReconciliation.getReconciliationNumber();
                break;
            }
            case "addCostId": {
                PurchaseAddCostDTO purchaseAddCostDTO = this.financeByIntegratedApiService.getAddCostHeadById(value);
                sourceNumber = purchaseAddCostDTO.getCostNumber();
                break;
            }
            case "deductCostId": {
                PurchaseDeductCostDTO purchaseDeductCostDTO = this.financeByIntegratedApiService.getDeductCostHeadById(value);
                sourceNumber = purchaseDeductCostDTO.getDeductNumber();
                break;
            }
            case "invoiceId": {
                PurchaseInvoiceDTO purchaseInvoiceDTO = this.financeByIntegratedApiService.getInvoiceById(value);
                sourceNumber = purchaseInvoiceDTO.getInvoiceNumber();
                break;
            }
            case "paymentApplyHeadId": {
                PurchasePaymentApplyHeadDTO purchasePaymentApplyHeadDTO = this.financeByIntegratedApiService.getPaymentApplyHeadById(value);
                sourceNumber = purchasePaymentApplyHeadDTO.getPaymentApplyNumber();
            }
        }
        return sourceNumber;
    }

    private void delNode(String type, String childId, IntegratedDocument document) {
        List<String> nodes = null;
        switch (type) {
            case "inqueryHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getInqueryHeadId())) break;
                nodes = new ArrayList<String>(Arrays.asList(document.getInqueryHeadId().split(",")));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setInqueryHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "ebiddingHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getEbiddingHeadId())) break;
                nodes = Arrays.asList(document.getEbiddingHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setEbiddingHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "biddingHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getBiddingHeadId())) break;
                nodes = Arrays.asList(document.getBiddingHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setBiddingHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "contractHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getContractHeadId())) break;
                nodes = Arrays.asList(document.getContractHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setContractHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "orderHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getOrderHeadId())) break;
                nodes = Arrays.asList(document.getOrderHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setOrderHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "deliveryNoticeId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getDeliveryNoticeId())) break;
                nodes = Arrays.asList(document.getDeliveryNoticeId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setDeliveryNoticeId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "purchaseDeliveryHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getPurchaseDeliveryHeadId())) break;
                nodes = Arrays.asList(document.getPurchaseDeliveryHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setPurchaseDeliveryHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "refundsDeliveryHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getRefundsDeliveryHeadId())) break;
                nodes = Arrays.asList(document.getRefundsDeliveryHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setRefundsDeliveryHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "voucherHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getVoucherHeadId())) break;
                nodes = Arrays.asList(document.getVoucherHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setVoucherHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "reconciliationId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getReconciliationId())) break;
                nodes = Arrays.asList(document.getReconciliationId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setReconciliationId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "addCostId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getAddCostId())) break;
                nodes = Arrays.asList(document.getAddCostId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setAddCostId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "deductCostId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getDeductCostId())) break;
                nodes = Arrays.asList(document.getDeductCostId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setDeductCostId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "invoiceId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getInvoiceId())) break;
                nodes = Arrays.asList(document.getInvoiceId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setInvoiceId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
            case "paymentApplyHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getPaymentApplyHeadId())) break;
                nodes = Arrays.asList(document.getPaymentApplyHeadId().split(","));
                Iterator<String> it = nodes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(childId)) continue;
                    it.remove();
                    document.setPaymentApplyHeadId(StringUtils.join(nodes, (String)","));
                }
                break;
            }
        }
    }

    private void setSourceId(String type, String childId, IntegratedDocument document) {
        switch (type) {
            case "inqueryHeadId": {
                document.setInqueryHeadId(childId);
                break;
            }
            case "ebiddingHeadId": {
                document.setEbiddingHeadId(childId);
                break;
            }
            case "biddingHeadId": {
                document.setBiddingHeadId(childId);
                break;
            }
            case "contractHeadId": {
                document.setContractHeadId(childId);
                break;
            }
            case "orderHeadId": {
                document.setOrderHeadId(childId);
                break;
            }
            case "deliveryNoticeId": {
                document.setDeliveryNoticeId(childId);
                break;
            }
            case "purchaseDeliveryHeadId": {
                document.setPurchaseDeliveryHeadId(childId);
                break;
            }
            case "refundsDeliveryHeadId": {
                document.setRefundsDeliveryHeadId(childId);
                break;
            }
            case "voucherHeadId": {
                document.setVoucherHeadId(childId);
                break;
            }
            case "reconciliationId": {
                document.setReconciliationId(childId);
                break;
            }
            case "addCostId": {
                document.setAddCostId(childId);
                break;
            }
            case "deductCostId": {
                document.setDeductCostId(childId);
                break;
            }
            case "invoiceId": {
                document.setInvoiceId(childId);
                break;
            }
            case "paymentApplyHeadId": {
                document.setPaymentApplyHeadId(childId);
            }
        }
    }

    private void setIntergratedDocumentId(String type, String documentId, String childId) {
        switch (type) {
            case "inqueryHeadId": {
                PurchaseEnquiryHeadDTO purchaseEnquiryHead = this.inquiryByIntegratedApiService.getEnquiryHeadById(childId);
                purchaseEnquiryHead.setDocumentId(documentId);
                this.inquiryByIntegratedApiService.updateEnquiryHeadById(purchaseEnquiryHead);
                break;
            }
            case "ebiddingHeadId": {
                PurchaseEbiddingHeadDTO purchaseEbiddingHead = this.inquiryByIntegratedApiService.getEbinddingHeadById(childId);
                purchaseEbiddingHead.setDocumentId(documentId);
                this.inquiryByIntegratedApiService.updateEbinddingHeadById(purchaseEbiddingHead);
                break;
            }
            case "biddingHeadId": {
                PurchaseBiddingHeadDTO purchaseBiddingHead = this.inquiryByIntegratedApiService.getBiddingHeadById(childId);
                purchaseBiddingHead.setDocumentId(documentId);
                this.inquiryByIntegratedApiService.updateBiddingHeadById(purchaseBiddingHead);
                break;
            }
            case "contractHeadId": {
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.purchaseContractHeadRpcService.getById(childId);
                purchaseContractHeadDTO.setFbk15(documentId);
                this.purchaseContractHeadRpcService.updateEntityById(purchaseContractHeadDTO);
                break;
            }
            case "orderHeadId": {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.orderByIntegratedApiService.getOrderHeadById(childId);
                purchaseOrderHeadDTO.setDocumentId(documentId);
                this.purchaseOrderHeadRpcService.updateById(purchaseOrderHeadDTO);
                List orderItemDTOList = this.purchaseOrderItemRpcService.selectByMainId(purchaseOrderHeadDTO.getId());
                orderItemDTOList.forEach(item -> item.setDocumentId(documentId));
                this.purchaseOrderItemRpcService.batchUpdate(orderItemDTOList);
            }
        }
    }

    private void getNodes(Map<String, Object> map, IntegratedDocument integratedDocument, List<Map<String, Object>> nodeList, List<Map<String, Object>> tempList) {
        map.forEach((k, v) -> {
            if (!v.equals("") && !v.equals("null")) {
                if (k.equals(IntegratedDocumentEnum.REQUEST_HEAD_ID.getValue())) {
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    node.put("id", v);
                    node.put("text", IntegratedDocumentEnum.getDesc((String)k) + "\n" + this.getSourceNumber((String)k, v.toString()));
                    node.put("url", IntegratedDocumentEnum.getUrl((String)k));
                    node.put("apiPath", IntegratedDocumentEnum.getApiPath((String)k));
                    nodeList.add(node);
                } else if (k.equals(IntegratedDocumentEnum.ORDER_HEAD_ID.getValue())) {
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    node.put("id", v);
                    node.put("text", IntegratedDocumentEnum.getDesc((String)k) + "\n" + this.getSourceNumber((String)k, v.toString()));
                    node.put("url", IntegratedDocumentEnum.getUrl((String)k));
                    node.put("apiPath", IntegratedDocumentEnum.getApiPath((String)k));
                    nodeList.add(node);
                } else {
                    List<String> values = Arrays.asList(v.toString().split(","));
                    values.forEach(value -> {
                        HashMap<String, String> tempNode = new HashMap<String, String>();
                        if (value.equals(integratedDocument.getRootId())) {
                            tempNode.put("styleClass", "my-node-style");
                        }
                        tempNode.put("id", (String)value);
                        tempNode.put("text", IntegratedDocumentEnum.getDesc((String)k) + "\n" + this.getSourceNumber((String)k, (String)value));
                        tempNode.put("url", IntegratedDocumentEnum.getUrl((String)k));
                        tempNode.put("apiPath", IntegratedDocumentEnum.getApiPath((String)k));
                        tempList.add(tempNode);
                    });
                }
            }
        });
    }
}

