/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.poi.excel.ExcelImportUtil;
import com.els.common.excel.poi.excel.entity.ExportParams;
import com.els.common.excel.poi.excel.entity.ImportParams;
import com.els.common.excel.poi.excel.view.ELSEntityExcelView;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.model.DictTree;
import com.els.modules.system.model.TreeSelectModel;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.vo.DictPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/base/dict"})
@Api(tags={"\u6570\u636e\u5b57\u5178"})
public class DictController {
    private static final Logger log = LoggerFactory.getLogger(DictController.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private I18nService i18nService;
    private static final String CATALOGUE = "sys:cache:dict";

    @PostMapping(value={"/noToken/sendMsg"})
    public Result<?> sendMsg(@RequestBody String body) {
        String msgKey = IdWorker.getIdStr();
        System.out.println(msgKey);
        MqUtil.sendBusMsg((String)body);
        return Result.ok();
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<Dict>> queryPageList(Dict sysDict, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDict, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.dictService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/listSys"}, method={RequestMethod.GET})
    public Result<IPage<Dict>> querySysPageList(Dict sysDict, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDict, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/listByDictCode"}, method={RequestMethod.GET})
    public Result<IPage<DictItem>> queryPageListByDictCode(Dict sysDict, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        LambdaQueryWrapper dictQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)dictQueryWrapper.eq(Dict::getElsAccount, (Object)TenantContext.getTenant())).eq(Dict::getDictCode, (Object)sysDict.getDictCode());
        Dict dict = (Dict)this.dictService.getOne((Wrapper)dictQueryWrapper);
        if (null == dict) {
            dictQueryWrapper.clear();
            ((LambdaQueryWrapper)dictQueryWrapper.eq(Dict::getElsAccount, (Object)"100000")).eq(Dict::getDictCode, (Object)sysDict.getDictCode());
            dict = (Dict)this.dictService.getOne((Wrapper)dictQueryWrapper);
        }
        if (null != dict) {
            DictItem dictItem = new DictItem();
            dictItem.setDictId(dict.getId());
            QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)dictItem, (Map)req.getParameterMap());
            queryWrapper.orderByAsc((Object)"sort_order");
            Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
            result.setSuccess(true);
            result.setResult((Object)pageList);
        }
        return result;
    }

    @RequestMapping(value={"/treeList"}, method={RequestMethod.GET})
    public Result<List<DictTree>> treeList(Dict sysDict, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        String dictName = sysDict.getDictName();
        if (ConvertUtils.isNotEmpty((Object)dictName)) {
            query.like(true, Dict::getDictName, (Object)dictName);
        }
        query.orderByDesc(true, (Object[])new SFunction[]{Dict::getCreateTime});
        List list = this.dictService.list((Wrapper)query);
        ArrayList<DictTree> treeList = new ArrayList<DictTree>();
        for (Dict node : list) {
            treeList.add(new DictTree(node));
        }
        result.setSuccess(true);
        result.setResult(treeList);
        return result;
    }

    @Caching(evict={@CacheEvict(value={"dictItems"}, allEntries=true), @CacheEvict(value={"rfPage"}, allEntries=true), @CacheEvict(value={"sys:cache:dictTable"}, allEntries=true), @CacheEvict(value={"sys:cache:dict"}, allEntries=true)})
    @RequestMapping(value={"/cleanCache"}, method={RequestMethod.GET})
    public Result<?> cleanCache() {
        log.info("\u6e05\u9664\u5b57\u5178\u7f13\u5b58");
        return Result.ok();
    }

    @RequestMapping(value={"/getBatchDictItems"}, method={RequestMethod.POST})
    public Result<List<DictPage>> getBatchDictItems(@RequestBody List<DictPage> dictList) {
        Result result = new Result();
        for (DictPage dict : dictList) {
            List<DictModel> ls = this.dictService.queryDictItemsByCode(dict.getDictCode(), TenantContext.getTenant());
            dict.setModelList(ls);
        }
        result.setResult(dictList);
        return result;
    }

    private String[] getParams(String dictCode) {
        return dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u660e\u7ec6", notes="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u660e\u7ec6")
    @RequestMapping(value={"/findDictItems"}, method={RequestMethod.POST})
    public Result<Object> findDictItems(@RequestBody DictPage dictPage) {
        log.info(" dictCode : " + dictPage.getDictCode());
        log.info(" busAccount : " + dictPage.getBusAccount());
        String elsAccount = StrUtil.isEmpty((CharSequence)dictPage.getBusAccount()) ? TenantContext.getTenant() : dictPage.getBusAccount();
        String dictCode = dictPage.getDictCode();
        Result result = new Result();
        List<Object> ls = new ArrayList();
        List<Object> maps = new ArrayList();
        try {
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = this.getParams(dictPage.getDictCode());
                if (params.length < 3) {
                    result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                SqlInjectionUtil.filterContent((String[])params);
                String filterSql = params.length == 4 ? params[3] : "";
                ls = this.dictService.queryTableDictItemsByCodeAndFilter(params[0], params[1], params[2], filterSql, elsAccount);
            } else {
                log.info("aaaaaaaaaaa");
                if (dictCode.contains(";")) {
                    log.info("batchCode:" + dictCode);
                    maps = this.dictService.queryDictItemsByCodeList(dictCode, elsAccount);
                    result.setSuccess(true);
                    result.setResult(maps);
                    log.info("resultData:" + result.toString());
                    return result;
                }
                log.info("bbbbbbbbbbbbb");
                ls = this.dictService.queryDictItemsByCode(dictCode, elsAccount);
            }
            result.setSuccess(true);
            result.setResult(ls);
            log.info("lsData:" + result.toString());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/getDictItems/{dictCode}"}, method={RequestMethod.GET})
    public Result<List<DictModel>> getDictItems(@PathVariable String dictCode) {
        String elsAccount = TenantContext.getTenant();
        String redisKey = CATALOGUE + elsAccount + ":" + dictCode;
        Result result = new Result();
        List<DictModel> ls = (List<DictModel>)this.redisUtil.get(redisKey);
        if (ls != null) {
            result.setSuccess(true);
            result.setResult((Object)ls);
            return result;
        }
        try {
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                if (params.length < 3) {
                    result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent((String[])sqlInjCheck);
                if (params.length == 4) {
                    SqlInjectionUtil.filterContent((String)params[3]);
                    ls = this.dictService.queryTableDictItemsByCodeAndFilter(params[0], params[1], params[2], params[3], elsAccount);
                } else {
                    if (params.length != 3) {
                        result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        return result;
                    }
                    ls = this.dictService.queryTableDictItemsByCode(params[0], params[1], params[2]);
                }
            } else {
                ls = this.dictService.queryDictItemsByCode(dictCode, TenantContext.getTenant());
                if (ls.isEmpty()) {
                    ls = this.dictService.queryDictItemsByCode(dictCode, "100000");
                    if (!ls.isEmpty()) {
                        this.redisUtil.set(redisKey, ls);
                    }
                } else {
                    this.redisUtil.set(redisKey, ls);
                }
            }
            result.setSuccess(true);
            result.setResult(ls);
            log.info(result.toString());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
    }

    @RequestMapping(value={"/getKeyword/{dictCode}"}, method={RequestMethod.GET})
    public Result<List<String>> getKeyword(@PathVariable String dictCode) {
        Result result = new Result();
        List<String> ls = null;
        try {
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                if (params.length < 3) {
                    result.error500("Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent((String[])sqlInjCheck);
                ls = this.dictService.queryTableKeyword(params[0], params[1], params[2]);
            }
            result.setSuccess(true);
            result.setResult(ls);
            log.info(result.toString());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/getDictText/{dictCode}/{key}"}, method={RequestMethod.GET})
    public Result<String> getDictItems(@PathVariable(value="dictCode") String dictCode, @PathVariable(value="key") String key) {
        log.info(" dictCode : " + dictCode);
        Result result = new Result();
        try {
            String text = this.dictService.queryDictTextByKey(dictCode, key, TenantContext.getTenant());
            result.setSuccess(true);
            result.setResult((Object)text);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<Dict> add(@RequestBody Dict sysDict) {
        Result result = new Result();
        try {
            sysDict.setCreateTime(new Date());
            sysDict.setDeleted(CommonConstant.DEL_FLAG_0);
            String inputkey = sysDict.getDictNameI18nKey();
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, new Object[]{inputkey})).list();
            Map<String, String> keyMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey));
            HashMap<String, String> nokeyMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)sysDict.getDictName()) && StringUtils.isBlank((String)sysDict.getDictNameI18nKey())) {
                String s = this.i18nService.checkAndAdd(sysDict.getDictName(), "dict");
                sysDict.setDictNameI18nKey(s);
            }
            this.i18nService.addOtherKey(nokeyMap);
            this.dictService.save(sysDict);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public Result<Dict> edit(@RequestBody Dict sysDict) {
        Result result = new Result();
        Dict sysdict = (Dict)this.dictService.getById((Serializable)((Object)sysDict.getId()));
        if (sysdict == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysDict.setUpdateTime(new Date());
            String inputkey = sysDict.getDictNameI18nKey();
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, new Object[]{inputkey})).list();
            Map<String, String> keyMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey));
            HashMap<String, String> nokeyMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)sysDict.getDictName()) && StringUtils.isBlank((String)sysDict.getDictNameI18nKey())) {
                String s = this.i18nService.checkAndAdd(sysDict.getDictName(), "dict");
                sysDict.setDictNameI18nKey(s);
            }
            boolean ok = this.dictService.updateById(sysDict);
            this.i18nService.addOtherKey(nokeyMap);
            if (ok) {
                result.success("\u7f16\u8f91\u6210\u529f!");
                this.redisUtil.set(CATALOGUE + TenantContext.getTenant() + ":" + sysDict.getDictCode(), null);
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<Dict> delete(@RequestParam(name="id") String id) {
        Result result = new Result();
        Dict sysdict = (Dict)this.dictService.getById((Serializable)((Object)id));
        boolean ok = this.dictService.removeById((Serializable)((Object)id));
        if (ok) {
            result.success("\u5220\u9664\u6210\u529f!");
            if (sysdict != null) {
                this.redisUtil.set(CATALOGUE + TenantContext.getTenant() + ":" + sysdict.getDictCode(), null);
            }
        } else {
            result.error500("\u5220\u9664\u5931\u8d25!");
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<Dict> deleteBatch(@RequestParam(name="ids") String ids) {
        Result result = new Result();
        if (ConvertUtils.isEmpty((Object)ids)) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.dictService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(Dict sysDict, HttpServletRequest request) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDict, (Map)request.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        ArrayList<DictPage> pageList = new ArrayList<DictPage>();
        List sysDictList = this.dictService.list((Wrapper)queryWrapper);
        for (Dict dictMain : sysDictList) {
            DictPage vo = new DictPage();
            BeanUtils.copyProperties((Object)dictMain, (Object)vo);
            List<DictItem> sysDictItemList = this.dictItemService.selectItemsByMainId(dictMain.getId());
            vo.setSysDictItemList(sysDictItemList);
            pageList.add(vo);
        }
        mv.addObject("fileName", (Object)"\u6570\u636e\u5b57\u5178");
        mv.addObject("entity", DictPage.class);
        LoginUser user = SysUtil.getLoginUser();
        mv.addObject("params", (Object)new ExportParams("\u6570\u636e\u5b57\u5178\u5217\u8868", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u6570\u636e\u5b57\u5178", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(2);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), DictPage.class, (ImportParams)params);
                for (DictPage page : list) {
                    Dict po = new Dict();
                    BeanUtils.copyProperties((Object)page, (Object)po);
                    if (page.getDeleted() == null) {
                        po.setDeleted(1);
                    }
                    this.dictService.saveMain(po, page.getSysDictItemList());
                }
                Result result = Result.ok((String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/loadDict/{dictCode}"}, method={RequestMethod.GET})
    public Result<List<DictModel>> loadDict(@PathVariable String dictCode, @RequestParam(name="keyword") String keyword) {
        log.info(" \u52a0\u8f7d\u5b57\u5178\u8868\u6570\u636e,\u52a0\u8f7d\u5173\u952e\u5b57: " + keyword);
        Result result = new Result();
        try {
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                if (params.length != 3) {
                    result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                List<DictModel> ls = this.dictService.queryTableDictItems(params[0], params[1], params[2], keyword);
                result.setSuccess(true);
                result.setResult(ls);
                log.info(result.toString());
            } else {
                result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/loadDictItem/{dictCode}"}, method={RequestMethod.GET})
    public Result<List<String>> loadDictItem(@PathVariable String dictCode, @RequestParam(name="key") String key) {
        Result result = new Result();
        try {
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                if (params.length != 3) {
                    result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                List<String> texts = this.dictService.queryTableDictByKeys(params[0], params[1], params[2], key.split(","));
                result.setSuccess(true);
                result.setResult(texts);
                log.info(result.toString());
            } else {
                result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/loadTreeData"}, method={RequestMethod.GET})
    public Result<List<TreeSelectModel>> loadDict(@RequestParam(name="pid") String pid, @RequestParam(name="pidField") String pidField, @RequestParam(name="tableName") String tbname, @RequestParam(name="text") String text, @RequestParam(name="code") String code, @RequestParam(name="hasChildField") String hasChildField, @RequestParam(name="condition") String condition) {
        Result result = new Result();
        Map query = null;
        if (ConvertUtils.isNotEmpty((Object)condition)) {
            query = (Map)JSON.parseObject((String)condition, Map.class);
        }
        List<TreeSelectModel> ls = this.dictService.queryTreeList(query, tbname, text, code, pidField, pid, hasChildField);
        result.setSuccess(true);
        result.setResult(ls);
        return result;
    }

    @RequestMapping(value={"/deleteList"}, method={RequestMethod.GET})
    public Result<List<Dict>> deleteList() {
        Result result = new Result();
        List<Dict> list = this.dictService.queryDeleteList();
        result.setSuccess(true);
        result.setResult(list);
        return result;
    }

    @RequestMapping(value={"/deletePhysic/{id}"}, method={RequestMethod.GET})
    public Result<?> deletePhysic(@PathVariable String id) {
        try {
            this.dictService.deleteOneDictPhysically(id);
            return Result.ok((String)"\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            return Result.error((String)"\u5220\u9664\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/back/{id}"}, method={RequestMethod.POST})
    public Result<?> back(@PathVariable String id) {
        try {
            this.dictService.updateDictDelFlag(0, id);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            return Result.error((String)"\u64cd\u4f5c\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/cleanRedisCache"}, method={RequestMethod.GET})
    public Result<Dict> cleanRedisCache(@RequestParam(name="id") String id) {
        Result result = new Result();
        Dict dict = (Dict)this.dictService.getById((Serializable)((Object)id));
        if (dict != null) {
            this.redisUtil.deleteByPrex(CATALOGUE + TenantContext.getTenant() + ":" + dict.getDictCode());
            result.success("\u6e05\u9664\u6210\u529f!");
        } else {
            result.error500("\u6e05\u9664\u5931\u8d25!");
        }
        return result;
    }

    @GetMapping(value={"/noToken/addDictI18nKey"})
    public Result<?> addDictI18nKey() {
        this.dictService.addDictI18nKey();
        return Result.ok((Object)3);
    }

    @GetMapping(value={"/addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(value="id") String id) {
        this.dictService.addToEnterprise(id);
        return Result.ok((Object)2);
    }
}

