/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.entity.ElsBarcodeAttribute;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.ElsBarcodeAttributeMapper;
import com.els.modules.barcode.service.ElsBarcodeAttributeService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsBarcodeAttributeServiceImpl
extends BaseServiceImpl<ElsBarcodeAttributeMapper, ElsBarcodeAttribute>
implements ElsBarcodeAttributeService {
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    public void saveElsBarcodeAttribute(ElsBarcodeAttribute elsBarcodeAttribute) {
        elsBarcodeAttribute.setAttributeStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        elsBarcodeAttribute.setAttributeNumber(this.codeGeneratorService.getNextCode("srmBarcodeAttrNumber", (Object)elsBarcodeAttribute));
        ((ElsBarcodeAttributeMapper)this.baseMapper).insert((Object)elsBarcodeAttribute);
    }

    @Override
    public void updateElsBarcodeAttribute(ElsBarcodeAttribute elsBarcodeAttribute) {
        int count = ((ElsBarcodeAttributeMapper)this.baseMapper).updateById((Object)elsBarcodeAttribute);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delElsBarcodeAttribute(String id) {
        ((ElsBarcodeAttributeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsBarcodeAttribute(List<String> idList) {
        ((ElsBarcodeAttributeMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

