/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integration.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.util.RedisUtil;
import com.els.modules.integration.service.CallInterfaceService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CallInterfaceServiceImpl
implements CallInterfaceService {
    private Logger logger = LoggerFactory.getLogger(CallInterfaceServiceImpl.class);
    @Value(value="${interface.url}")
    private String url;
    @Value(value="${interface.tokenUrl}")
    private String tokenUrl;
    @Value(value="${interface.elsAccount}")
    private String elsAccount;
    @Value(value="${interface.appId}")
    private String appId;
    @Value(value="${interface.appSerect}")
    private String appSerect;
    @Autowired
    private RedisUtil redisUtil;
    private static final String INTERFACE_TOKEN = "INTERFACE_TOKEN";
    private static final String INTERFACE_START_TIME = "INTERFACE_START_TIME";
    private static final String EFFECT_TIME = "EFFECT_TIME";
    private static final String TOKEN_SUCCESS = "200";
    private static final String SUCCES = "S";

    @Override
    public String getToken(String account, String link, String id, String serect) {
        return this.refuashToken(account, link, id, serect);
    }

    public String refuashToken(String account, String link, String id, String serect) {
        String url = null;
        url = link.endsWith("/") ? link + account + "/" + id + "/" + serect : link + "/" + account + "/" + id + "/" + serect;
        try {
            String reponse = HttpRequest.get((String)url).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)reponse);
            if (TOKEN_SUCCESS.equals(jsonObject.getString("statusCode"))) {
                this.redisUtil.set(INTERFACE_TOKEN, (Object)jsonObject.getString("accessToken"));
                this.redisUtil.set(INTERFACE_START_TIME, jsonObject.get((Object)"startTime"));
                this.redisUtil.set(EFFECT_TIME, (Object)jsonObject.getString("expires"));
                return jsonObject.getString("accessToken");
            }
            this.logger.error("token\u83b7\u53d6\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        catch (Exception e) {
            this.logger.error("token\u83b7\u53d6\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a", (Throwable)e);
        }
        return null;
    }

    @Override
    public JSONObject callInterfacePost(String interfaceCode, JSONObject realbody) {
        JSONObject object = new JSONObject();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("elsAccount", this.elsAccount);
        headers.put("accessToken", this.getToken(this.elsAccount, this.tokenUrl, this.appId, this.appSerect));
        JSONObject request = new JSONObject();
        request.put("account", (Object)this.elsAccount);
        request.put("code", (Object)interfaceCode);
        request.put("type", (Object)"json");
        request.put("data", (Object)realbody);
        try {
            String reponse = ((HttpRequest)HttpRequest.post((String)this.url).addHeaders(headers)).body(request.toString()).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)reponse);
            if (SUCCES.equals(jsonObject.getString("status"))) {
                object.put("success", (Object)true);
                object.put("code", (Object)CommonConstant.SC_OK_200);
                if (jsonObject.getString("data") != null) {
                    object.put("result", (Object)jsonObject.getString("data"));
                    object.put("message", (Object)jsonObject.getString("data"));
                } else {
                    object.put("result", (Object)jsonObject.getString("array"));
                    object.put("message", (Object)jsonObject.getString("array"));
                }
            } else {
                object.put("success", (Object)false);
                object.put("code", (Object)CommonConstant.SC_INTERNAL_SERVER_ERROR_500);
                object.put("message", (Object)jsonObject.getString("message"));
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            object.put("success", (Object)false);
            object.put("code", (Object)CommonConstant.SC_INTERNAL_SERVER_ERROR_500);
            object.put("message", (Object)e.getMessage());
        }
        return object;
    }
}

