/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logistics.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.modules.logistics.entity.LogisticsCompanyItem;
import com.els.modules.logistics.vo.LogisticsCompanyVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/trace"})
@CrossOrigin(value={"*"})
public class TraceController {
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @GetMapping(value={"/express"})
    public Result<?> selectExpress(@RequestParam(name="expressNumber") String expressNumber) throws Exception {
        if (!StringUtils.isEmpty((Object)expressNumber)) {
            JSONObject request = new JSONObject();
            request.put("num", (Object)expressNumber);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getExpressInfo"));
            if ("200".equals(object.getString("code"))) {
                JSONObject jsonObject = JSONObject.parseObject((String)object.getString("data"));
                if ("0".equals(jsonObject.getString("status")) || "200".equals(jsonObject.getString("status"))) {
                    return Result.ok((Object)((Object)this.jsonResult(jsonObject)));
                }
                return Result.error((String)jsonObject.getString("message"));
            }
            return Result.error((String)object.getString("message"));
        }
        return Result.error((String)"\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a!");
    }

    private LogisticsCompanyVO jsonResult(JSONObject jsonObject) {
        LogisticsCompanyVO logisticsCompanyVO = new LogisticsCompanyVO();
        logisticsCompanyVO.setCurrent(jsonObject.getString("current"));
        logisticsCompanyVO.setCurrentStatus(jsonObject.getString("currentStatus"));
        logisticsCompanyVO.setLatestTime(jsonObject.getString("latest_time"));
        logisticsCompanyVO.setLatestProgress(jsonObject.getString("latest_progress"));
        logisticsCompanyVO.setCompanyName(jsonObject.getString("fullname"));
        logisticsCompanyVO.setCompanyNameIcon(jsonObject.getString("title_logo"));
        ArrayList<LogisticsCompanyItem> objects = new ArrayList<LogisticsCompanyItem>();
        JSONArray context = jsonObject.getJSONArray("data");
        context.forEach(item -> this.jsonToitem((JSONObject)item, objects));
        logisticsCompanyVO.setLogisticsCompanyItemList(objects);
        return logisticsCompanyVO;
    }

    private void jsonToitem(JSONObject jsonObject, List<LogisticsCompanyItem> objects) {
        LogisticsCompanyItem logisticsCompanyItem = new LogisticsCompanyItem();
        Date time = jsonObject.getDate("time");
        logisticsCompanyItem.setAcceptTime(time);
        logisticsCompanyItem.setAcceptStation(jsonObject.getString("context"));
        objects.add(logisticsCompanyItem);
    }
}

