/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.ColumnDefine;
import com.els.modules.system.mapper.ColumnDefineMapper;
import com.els.modules.system.service.ColumnDefineService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ColumnDefineServiceImpl
extends ServiceImpl<ColumnDefineMapper, ColumnDefine>
implements ColumnDefineService {
    @Autowired
    private I18nService i18nService;

    @Override
    public void addColumnI18nKey() {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(ColumnDefine::getColumnNameI18nKey)).eq(ColumnDefine::getElsAccount, (Object)"100000")).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List<String> collect = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            collect = list.parallelStream().map(o -> o.getColumnName()).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(collect)) {
            Map<String, String> stringStringMap = this.i18nService.checkAndAdd(collect, "field");
            list.forEach(item -> item.setColumnNameI18nKey((String)stringStringMap.get(item.getColumnName())));
            this.updateBatchById(list);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addToEnterpriseLevel(HashMap<String, String> map) {
        String ids = map.get("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        Assert.isTrue((!CollectionUtil.isEmpty(idList) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_VRRiFIAHcbLW_eb724e13", (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u5217\u8fdb\u884c\u751f\u6210\uff01"));
        List columnDefineList = this.listByIds(idList);
        ArrayList<String> tableCodes = new ArrayList<String>();
        for (ColumnDefine define : columnDefineList) {
            if (tableCodes.contains(define.getTableCode())) continue;
            tableCodes.add(define.getTableCode());
        }
        String elsAccount = TenantContext.getTenant();
        String subAccount = SysUtil.getLoginUser() != null ? SysUtil.getLoginUser().getSubAccount() : "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"table_code", tableCodes);
        List oldList = this.list((Wrapper)queryWrapper);
        ArrayList<String> oldIds = new ArrayList<String>();
        ArrayList<ColumnDefine> newColumnDefineList = new ArrayList<ColumnDefine>();
        for (ColumnDefine define : columnDefineList) {
            define.setId(null);
            define.setElsAccount(elsAccount);
            define.setCreateBy(subAccount);
            define.setUpdateBy(subAccount);
            define.setCreateTime(new Date());
            define.setUpdateTime(new Date());
            newColumnDefineList.add(define);
            for (ColumnDefine oldDefine : oldList) {
                if (!oldDefine.getTableCode().equals(define.getTableCode()) || !oldDefine.getColumnCode().equals(define.getColumnCode()) || oldIds.contains(oldDefine.getId())) continue;
                oldIds.add(oldDefine.getId());
            }
        }
        this.removeByIds(oldIds);
        this.saveBatch(newColumnDefineList);
    }
}

