/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.excel.poi.excel.ExcelImportUtil;
import com.els.common.excel.poi.excel.entity.ExportParams;
import com.els.common.excel.poi.excel.entity.ImportParams;
import com.els.common.excel.poi.excel.view.ELSEntityExcelView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.entity.SaleBarcodeInfoDetail;
import com.els.modules.barcode.entity.SaleBarcodeInfoHead;
import com.els.modules.barcode.entity.SaleBarcodeInfoItem;
import com.els.modules.barcode.service.SaleBarcodeInfoDetailService;
import com.els.modules.barcode.service.SaleBarcodeInfoHeadService;
import com.els.modules.barcode.service.SaleBarcodeInfoItemService;
import com.els.modules.barcode.vo.SaleBarcodeInfoHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/base/barcode/saleBarcodeInfoHead"})
@Api(tags={"\u9500\u552e\u6761\u7801\u5355\u5934\u8868"})
public class SaleBarcodeInfoHeadController
extends BaseController<SaleBarcodeInfoHead, SaleBarcodeInfoHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleBarcodeInfoHeadController.class);
    @Autowired
    private SaleBarcodeInfoHeadService saleBarcodeInfoHeadService;
    @Autowired
    private SaleBarcodeInfoItemService saleBarcodeInfoItemService;
    @Autowired
    private SaleBarcodeInfoDetailService saleBarcodeInfoDetailService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleBarcodeInfoHead saleBarcodeInfoHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleBarcodeInfoHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleBarcodeInfoHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5355\u5934\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SaleBarcodeInfoHeadVO saleBarcodeInfoHeadPage) {
        SaleBarcodeInfoHead saleBarcodeInfoHead = new SaleBarcodeInfoHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodeInfoHeadPage), (Object)((Object)saleBarcodeInfoHead));
        this.saleBarcodeInfoHeadService.saveMain(saleBarcodeInfoHead, saleBarcodeInfoHeadPage.getPurchaseBarcodeInfoItemList(), saleBarcodeInfoHeadPage.getSysBarcodeList(), saleBarcodeInfoHeadPage.getCustomBarcodeList());
        return Result.ok((Object)((Object)saleBarcodeInfoHead));
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5355\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SaleBarcodeInfoHeadVO saleBarcodeInfoHeadPage) {
        SaleBarcodeInfoHead saleBarcodeInfoHead = new SaleBarcodeInfoHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodeInfoHeadPage), (Object)((Object)saleBarcodeInfoHead));
        this.saleBarcodeInfoHeadService.updateMain(saleBarcodeInfoHead, saleBarcodeInfoHeadPage.getPurchaseBarcodeInfoItemList(), saleBarcodeInfoHeadPage.getSysBarcodeList(), saleBarcodeInfoHeadPage.getCustomBarcodeList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5355\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleBarcodeInfoHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5355\u5934\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleBarcodeInfoHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleBarcodeInfoHead saleBarcodeInfoHead = (SaleBarcodeInfoHead)((Object)this.saleBarcodeInfoHeadService.getById((Serializable)((Object)id)));
        SaleBarcodeInfoHeadVO saleBarcodeInfoHeadVO = new SaleBarcodeInfoHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleBarcodeInfoHead), (Object)((Object)saleBarcodeInfoHeadVO));
        List<SaleBarcodeInfoItem> saleBarcodeInfoItemList = this.saleBarcodeInfoItemService.selectByMainId(id);
        saleBarcodeInfoHeadVO.setPurchaseBarcodeInfoItemList(saleBarcodeInfoItemList);
        List<SaleBarcodeInfoDetail> saleBarcodeInfoDetailList = this.saleBarcodeInfoDetailService.selectByMainId(id);
        List<SaleBarcodeInfoDetail> sysBarcodeList = saleBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 1).collect(Collectors.toList());
        saleBarcodeInfoHeadVO.setSysBarcodeList(sysBarcodeList);
        List<SaleBarcodeInfoDetail> customBarcodeList = saleBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 2).collect(Collectors.toList());
        saleBarcodeInfoHeadVO.setCustomBarcodeList(customBarcodeList);
        return Result.ok((Object)((Object)saleBarcodeInfoHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5355\u884c\u8868", notes="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5355\u884c\u8868")
    @GetMapping(value={"/querySaleBarcodeInfoItemByMainId"})
    public Result<?> querySaleBarcodeInfoItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleBarcodeInfoItem> saleBarcodeInfoItemList = this.saleBarcodeInfoItemService.selectByMainId(id);
        return Result.ok(saleBarcodeInfoItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u660e\u7ec6\u8868", notes="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u660e\u7ec6\u8868")
    @GetMapping(value={"/querySaleBarcodeInfoDetailByMainId"})
    public Result<?> querySaleBarcodeInfoDetailListByMainId(@RequestParam(name="id") String id) {
        List<SaleBarcodeInfoDetail> saleBarcodeInfoDetailList = this.saleBarcodeInfoDetailService.selectByMainId(id);
        return Result.ok(saleBarcodeInfoDetailList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SaleBarcodeInfoHead saleBarcodeInfoHead) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleBarcodeInfoHead), (Map)request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<SaleBarcodeInfoHeadVO> pageList = new ArrayList<SaleBarcodeInfoHeadVO>();
        List saleBarcodeInfoHeadList = this.saleBarcodeInfoHeadService.list((Wrapper)queryWrapper);
        for (SaleBarcodeInfoHead temp : saleBarcodeInfoHeadList) {
            SaleBarcodeInfoHeadVO vo = new SaleBarcodeInfoHeadVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<SaleBarcodeInfoItem> saleBarcodeInfoItemList = this.saleBarcodeInfoItemService.selectByMainId(temp.getId());
            vo.setPurchaseBarcodeInfoItemList(saleBarcodeInfoItemList);
            List<SaleBarcodeInfoDetail> saleBarcodeInfoDetailList = this.saleBarcodeInfoDetailService.selectByMainId(temp.getId());
            List<SaleBarcodeInfoDetail> sysBarcodeList = saleBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 1).collect(Collectors.toList());
            vo.setSysBarcodeList(sysBarcodeList);
            List<SaleBarcodeInfoDetail> customBarcodeList = saleBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 2).collect(Collectors.toList());
            vo.setCustomBarcodeList(customBarcodeList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)I18nUtil.translate((String)"i18n_alert_XlToteB_43857f9b", (String)"\u9500\u552e\u6761\u7801\u5355\u5934\u8868"));
        mv.addObject("entity", SaleBarcodeInfoHeadVO.class);
        mv.addObject("params", (Object)new ExportParams("\u9500\u552e\u6761\u7801\u5355\u5934\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u9500\u552e\u6761\u7801\u5355\u5934\u8868"));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SaleBarcodeInfoHeadVO.class, (ImportParams)params);
                for (SaleBarcodeInfoHeadVO page : list) {
                    SaleBarcodeInfoHead po = new SaleBarcodeInfoHead();
                    BeanUtils.copyProperties((Object)((Object)page), (Object)((Object)po));
                    this.saleBarcodeInfoHeadService.saveMain(po, page.getPurchaseBarcodeInfoItemList(), page.getSysBarcodeList(), page.getCustomBarcodeList());
                }
                Result result = Result.ok((String)I18nUtil.translate((String)"i18n_alert_QIuNLRWWFcW_6e8a1fc", (String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:${0}", (String[])new String[]{String.valueOf(list.size())}));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)(I18nUtil.translate((String)"i18n_alert_QIuNKm_c396138c", (String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:") + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

