/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.rpc.service.BaseInvokeExcelItemExecuteService;
import com.els.modules.system.service.ExcelItemExcelService;
import com.els.modules.system.util.ExcelCellStyleStrategy;
import com.els.modules.system.util.ExcelDataListener;
import com.els.modules.system.util.ExcelDictWriteHandler;
import com.els.modules.system.util.ExcelEnquiryCellStrategy;
import com.els.modules.system.util.ExcelEnquiryCellWriteCellStyle;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.modules.system.util.ExcelSaleEnquiryDataListener;
import com.els.modules.system.vo.SaleEnquiryCostQuotePriceGroupVO;
import com.els.modules.system.vo.SaleEnquiryQuotePriceVO;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelItemExcelServiceImpl
implements ExcelItemExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExcelItemExcelServiceImpl.class);
    @Resource
    private BaseInvokeExcelItemExecuteService baseInvokeExcelItemExecuteService;
    @Resource
    private TemplateHeadService templateHeadService;
    @Resource
    private TemplateConfigHeadService templateConfigHeadService;
    @Resource
    private TemplateConfigItemService templateConfigItemService;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    public Integer sheetNum;

    private List<TemplateConfigItem> getTemplate(ExcelByConfigDTO excelByConfigDTO, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        List itemList = excelItemByConfigRpcService.getTemplate(excelByConfigDTO).getTemplateConfigItemList();
        List<Object> listNew = SysUtil.copyProperties((List)itemList, TemplateConfigItem.class);
        if (StringUtils.isBlank((CharSequence)excelByConfigDTO.getGroupCode())) {
            return listNew;
        }
        listNew = listNew.stream().filter(item -> excelByConfigDTO.getGroupCode().equals(item.getGroupCode())).collect(Collectors.toList());
        return listNew;
    }

    private List<ExcelDetail> getExcelDetail(ExcelByConfigDTO excelByConfigDTO, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        ArrayList<ExcelDetail> detailList = new ArrayList<ExcelDetail>();
        List<TemplateConfigItem> itemList = this.getTemplate(excelByConfigDTO, excelItemByConfigRpcService);
        if (CollectionUtil.isNotEmpty(itemList)) {
            String SALE = "sale";
            int index = 1;
            for (TemplateConfigItem item : itemList) {
                boolean editFlag;
                boolean showFlag = SALE.equals(excelByConfigDTO.getRoleCode()) ? "1".equals(item.getSaleShow()) : "1".equals(item.getPurchaseShow());
                if (!showFlag) continue;
                ExcelDetail detail = new ExcelDetail();
                detail.setElsAccount(item.getElsAccount());
                detail.setColumnCode(item.getFieldName());
                detail.setColumnName(item.getFieldLabel());
                detail.setColumnIndex(index++);
                boolean bl = editFlag = SALE.equals(excelByConfigDTO.getRoleCode()) ? "1".equals(item.getSaleEdit()) : "1".equals(item.getPurchaseEdit());
                if (editFlag && "1".equals(item.getRequired())) {
                    detail.setRequired(CommonConstant.STATUS_YES);
                }
                detail.setPrimaryKey(CommonConstant.STATUS_NO);
                detail.setDataType(ExcelDataTypeEnum.STRING.getCode());
                if (!(!StringUtils.isNotBlank((CharSequence)item.getDictCode()) || item.getDictCode().contains(",") && item.getDictCode().contains("#"))) {
                    detail.setDataType(ExcelDataTypeEnum.DICT.getCode());
                    detail.setDataFormat(item.getDictCode());
                } else if ("number".equals(item.getFieldType()) || "float".equals(item.getFieldType()) || "computed".equals(item.getFieldType())) {
                    detail.setDataType(ExcelDataTypeEnum.NUMBER.getCode());
                } else if ("date".equals(item.getFieldType())) {
                    detail.setDataType(ExcelDataTypeEnum.DATE.getCode());
                    detail.setDataFormat(item.getDataFormat());
                }
                detailList.add(detail);
            }
        }
        return detailList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO, List<ExcelDetail> detailList, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        String elsAccount = StringUtils.isBlank((CharSequence)excelByConfigDTO.getBusAccount()) ? TenantContext.getTenant() : excelByConfigDTO.getBusAccount();
        List result = excelItemByConfigRpcService.getExportData(excelByConfigDTO);
        log.error("getExportDataClass:" + result.get(0).getClass().getName());
        log.error("getExportData:" + result.get(0).toString());
        if (!CollectionUtil.isNotEmpty((Collection)result)) return result;
        Map<String, String> dictMap = detailList.stream().filter(detail -> ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())).collect(Collectors.toMap(ExcelDetail::getColumnCode, ExcelDetail::getDataFormat));
        HashMap<String, List> listMap = new HashMap<String, List>();
        for (String string : dictMap.values()) {
            List dictList;
            if (listMap.containsKey(string)) continue;
            log.info("ExcelItemExcelServiceImpl getExportData:{}", (Object)string);
            if (string.contains("#") || string.contains(",")) {
                String[] params = string.contains("#") ? string.split("#") : string.split(",");
                if (params.length < 3) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent((String[])sqlInjCheck);
                if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
                String string2 = params[3];
                SqlInjectionUtil.filterContent((String)string2);
                log.info("ExcelItemExcelServiceImpl queryTableDictListByFilterSql");
                dictList = this.invokeBaseRpcService.queryTableDictListByFilterSql(elsAccount, params[0], params[1], params[2], string2);
            } else {
                log.info("ExcelItemExcelServiceImpl queryDictItemsByCode");
                dictList = this.invokeBaseRpcService.queryDictItemsByCode(string, elsAccount);
            }
            listMap.put(string, dictList);
        }
        Object data = result.get(0);
        if (data instanceof Map) {
            for (Object object : result) {
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!dictMap.containsKey(key)) continue;
                    List dictList = (List)listMap.get(dictMap.get(key));
                    this.translation((List<DictDTO>)dictList, map, key);
                }
            }
            return result;
        } else {
            Field[] fieldArray = ConvertUtils.getAllFields(data);
            for (Object object : result) {
                for (Field field : fieldArray) {
                    if (!dictMap.containsKey(field.getName())) continue;
                    List dictList = (List)listMap.get(dictMap.get(field.getName()));
                    this.translation((List<DictDTO>)dictList, object, field);
                }
            }
        }
        return result;
    }

    private void translation(List<DictDTO> dictList, Object object, Field field) {
        try {
            field.setAccessible(true);
            String value = (String)field.get(object);
            for (DictDTO model : dictList) {
                if (!model.getValue().equals(value)) continue;
                field.set(object, model.getText());
                return;
            }
        }
        catch (Exception e) {
            throw new ELSBootException("\u53cd\u5c04\u5f02\u5e38", (Throwable)e, new String[0]);
        }
    }

    private void translation(List<DictDTO> dictList, Map map, String key) {
        for (DictDTO model : dictList) {
            if (!model.getValue().equals(map.get(key))) continue;
            map.put(key, model.getText());
            return;
        }
    }

    private List<String> includeColumn(List<ExcelDetail> detailList) {
        return detailList.stream().map(ExcelDetail::getColumnCode).collect(Collectors.toList());
    }

    @Override
    public void download(HttpServletResponse response, ExcelByConfigDTO excelByConfigDTO) {
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(excelByConfigDTO.getHandlerName());
        List<ExcelDetail> detailList = this.getExcelDetail(excelByConfigDTO, excelItemByConfigRpcService);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u5165\u6a21\u677f.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList, this.invokeBaseRpcService)).head(ExcelHeaderUtil.getHeaderList(detailList)).sheet("data").doWrite(new ArrayList(16));
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @Override
    public void exportExcel(HttpServletResponse response, ExcelByConfigDTO excelByConfigDTO) {
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(excelByConfigDTO.getHandlerName());
        List<ExcelDetail> detailList = this.getExcelDetail(excelByConfigDTO, excelItemByConfigRpcService);
        List<Object> data = this.getExportData(excelByConfigDTO, detailList, excelItemByConfigRpcService);
        log.error("dataSize:" + data.size());
        log.error("dataName:" + data.get(0).getClass().getName());
        List<String> includeColumnSet = this.includeColumn(detailList);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u51fa\u6570\u636e.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).build();
            WriteSheet sheet1 = EasyExcel.writerSheet((Integer)0, (String)"data").registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList, this.invokeBaseRpcService, this, excelByConfigDTO.getBusAccount())).includeColumnFiledNames(includeColumnSet).head(ExcelHeaderUtil.getHeaderList(detailList)).build();
            excelWriter.write(data, sheet1);
            if ("saleEnquiryItemExcelRpcServiceImpl".equals(excelByConfigDTO.getHandlerName())) {
                this.buildSaleEnquiryQuoteType(excelWriter, data);
            }
            excelWriter.finish();
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> importExcel(ExcelByConfigDTO excelByConfigDTO, MultipartFile file) {
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(excelByConfigDTO.getHandlerName());
        List<ExcelDetail> detailList = this.getExcelDetail(excelByConfigDTO, excelItemByConfigRpcService);
        try (InputStream inputStream = file.getInputStream();){
            List<Map<String, Object>> otherSheetList = null;
            if ("saleEnquiryItemExcelRpcServiceImpl".equals(excelByConfigDTO.getHandlerName())) {
                otherSheetList = this.readSaleEnquiryQuoteType(file);
            }
            ExcelDataListener listener = new ExcelDataListener((ExcelImportRpcService)excelItemByConfigRpcService, detailList, null, this.invokeBaseRpcService, otherSheetList);
            EasyExcel.read((InputStream)inputStream, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(0)).doRead();
            List<Map<String, Object>> list = listener.getImportDataList();
            return list;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    private void buildSaleEnquiryQuoteType(ExcelWriter excelWriter, List<Object> data) {
        List costWayList;
        JSONObject jsonObject;
        List quotePriceWayList = data.stream().filter(a -> {
            JSONObject obj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)a));
            return "1".equals(obj.getString("quotePriceWay")) || "\u9636\u68af\u62a5\u4ef7".equals(obj.getString("quotePriceWay"));
        }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(quotePriceWayList)) {
            Object obj2;
            ArrayList<SaleEnquiryQuotePriceVO> dataList = new ArrayList<SaleEnquiryQuotePriceVO>();
            for (Object obj2 : quotePriceWayList) {
                jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(obj2));
                List jsonArray = JSONArray.parseArray((String)jsonObject.getString("ladderPriceJson"), JSONObject.class);
                for (JSONObject jsonObject1 : jsonArray) {
                    SaleEnquiryQuotePriceVO vo = new SaleEnquiryQuotePriceVO();
                    vo.setItemNumber(jsonObject.getString("itemNumber"));
                    vo.setMaterialNumber(jsonObject.getString("materialNumber"));
                    vo.setLadder(jsonObject1.getString("ladder"));
                    vo.setLadderQuantity(jsonObject1.getString("ladderQuantity"));
                    dataList.add(vo);
                }
            }
            Iterator iterator = this.sheetNum;
            this.sheetNum = this.sheetNum + 1;
            obj2 = this.sheetNum;
            WriteSheet sheet2 = EasyExcel.writerSheet((Integer)this.sheetNum, (String)"\u9636\u68af\u62a5\u4ef7").head(SaleEnquiryQuotePriceVO.class).needHead(Boolean.valueOf(true)).build();
            excelWriter.write(dataList, sheet2);
        }
        if (CollectionUtil.isNotEmpty(costWayList = data.stream().filter(a -> {
            JSONObject obj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)a));
            return "2".equals(obj.getString("quotePriceWay")) || "\u6210\u672c\u62a5\u4ef7".equals(obj.getString("quotePriceWay"));
        }).collect(Collectors.toList()))) {
            for (Object obj2 : costWayList) {
                jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(obj2));
                JSONObject costJSon = JSONObject.parseObject((String)jsonObject.getString("costFormJson"));
                QueryWrapper headQueryWrapper = new QueryWrapper();
                headQueryWrapper.lambda().eq(BaseEntity::getElsAccount, costJSon.get((Object)"templateAccount"));
                headQueryWrapper.lambda().eq(TemplateHead::getTemplateNumber, costJSon.get((Object)"templateNumber"));
                headQueryWrapper.lambda().eq(TemplateHead::getTemplateVersion, costJSon.get((Object)"templateVersion"));
                headQueryWrapper.last("limit 1");
                TemplateHead head = (TemplateHead)((Object)this.templateHeadService.getOne((Wrapper)headQueryWrapper));
                List<TemplateConfigHead> headList = this.templateConfigHeadService.selectByMainId(head.getId());
                List<TemplateConfigItem> itemList = this.templateConfigItemService.selectByMainId(head.getId());
                Integer n = this.sheetNum;
                Integer n2 = this.sheetNum = Integer.valueOf(this.sheetNum + 1);
                WriteSheet sheet2 = EasyExcel.writerSheet((Integer)this.sheetNum, (String)("\u6210\u672c\u62a5\u4ef7-" + jsonObject.getString("materialNumber"))).needHead(Boolean.valueOf(true)).registerWriteHandler((WriteHandler)new ExcelEnquiryCellStrategy()).registerWriteHandler((WriteHandler)new ExcelEnquiryCellWriteCellStyle()).build();
                List groups = JSONArray.parseArray((String)costJSon.getString("groups"), SaleEnquiryCostQuotePriceGroupVO.class);
                boolean i = false;
                ArrayList excelHeadList = new ArrayList();
                for (SaleEnquiryCostQuotePriceGroupVO group : groups) {
                    ArrayList<String> excelItemCodeList = new ArrayList<String>();
                    ArrayList<String> excelItemNameList = new ArrayList<String>();
                    excelItemCodeList.add(group.getGroupCode());
                    excelItemCodeList.add(group.getGroupName());
                    excelItemNameList.add(group.getGroupCode());
                    excelItemNameList.add(group.getGroupName());
                    List groupList = itemList.stream().filter(info -> group.getGroupCode().equals(info.getGroupCode())).collect(Collectors.toList());
                    if (groupList.size() > 0) {
                        for (TemplateConfigItem item : groupList) {
                            excelItemCodeList.add(item.getFieldName());
                            excelItemNameList.add(item.getFieldLabel());
                        }
                    } else {
                        List headGroupList = headList.stream().filter(info -> group.getGroupCode().equals(info.getGroupCode())).collect(Collectors.toList());
                        for (TemplateConfigHead configHead : headGroupList) {
                            excelItemCodeList.add(configHead.getFieldName());
                            excelItemNameList.add(configHead.getFieldLabel());
                        }
                    }
                    excelHeadList.add(excelItemCodeList);
                    excelHeadList.add(excelItemNameList);
                    ArrayList<String> excelItemCodeList2 = new ArrayList<String>();
                    excelItemCodeList2.add(group.getGroupCode());
                    excelItemCodeList2.add(group.getGroupName());
                    excelHeadList.add(excelItemCodeList2);
                    if (groupList.size() <= 0) continue;
                    excelHeadList.add(excelItemCodeList2);
                    excelHeadList.add(excelItemCodeList2);
                }
                excelWriter.write(excelHeadList, sheet2);
            }
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
    }

    private List<Map<String, Object>> readSaleEnquiryQuoteType(MultipartFile file) {
        try {
            HashMap<String, List<Map<String, Object>>> costDataList = new HashMap<String, List<Map<String, Object>>>();
            InputStream inputStream = file.getInputStream();
            ExcelSaleEnquiryDataListener listener = new ExcelSaleEnquiryDataListener();
            ExcelReader excelReader = EasyExcel.read((InputStream)inputStream, (ReadListener)listener).headRowNumber(Integer.valueOf(0)).build();
            List sheets = excelReader.excelExecutor().sheetList();
            if (CollectionUtils.isEmpty((Collection)sheets)) {
                return null;
            }
            Integer sheetTotalNum = sheets.size();
            for (ReadSheet sheet : sheets) {
                if (!sheet.getSheetName().contains("\u9636\u68af\u62a5\u4ef7") && !sheet.getSheetName().contains("\u6210\u672c\u62a5\u4ef7")) continue;
                listener.setRow(0);
                listener.setTempCostDataMap(new HashMap<String, List<String>>());
                listener.setSheetCostDataMap(new ArrayList<Map<String, Object>>());
                excelReader.read(new ReadSheet[]{sheet});
                if (!sheet.getSheetName().contains("\u6210\u672c\u62a5\u4ef7")) continue;
                String materialNumber = sheet.getSheetName().replaceAll("\u6210\u672c\u62a5\u4ef7-", "");
                costDataList.put(materialNumber, listener.getSheetCostDataMap());
            }
            List<Map<String, Object>> list = listener.getDataList();
            HashMap<String, HashMap<String, List<Map<String, Object>>>> costMap = new HashMap<String, HashMap<String, List<Map<String, Object>>>>();
            costMap.put("costPrice", costDataList);
            list.add(costMap);
            return list;
        }
        catch (IOException e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }
}

