/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.mapper.ElsTaxMapper;
import com.els.modules.system.service.ElsTaxService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsTaxServiceImpl
extends ServiceImpl<ElsTaxMapper, ElsTax>
implements ElsTaxService {
    @Autowired
    private InterfaceUtil interfaceUtil;

    @Override
    public void saveElsTax(ElsTax elsTax) {
        Boolean isExist = this.checkTaxIsRepeat(elsTax);
        Assert.isTrue((isExist == false ? 1 : 0) != 0, (String)"\u5f53\u524d\u6dfb\u52a0\u7684\u7a0e\u7387-\u7a0e\u7801\u8bb0\u5f55\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728");
        ((ElsTaxMapper)this.baseMapper).insert((Object)elsTax);
    }

    private Boolean checkTaxIsRepeat(ElsTax elsTax) {
        List elsTaxes;
        LambdaQueryWrapper elsTaxLambdaQueryWrapper = new LambdaQueryWrapper();
        elsTaxLambdaQueryWrapper.eq(ElsTax::getTaxCode, (Object)elsTax.getTaxCode());
        elsTaxLambdaQueryWrapper.eq(ElsTax::getTaxRate, (Object)elsTax.getTaxRate());
        if (StringUtils.isNotEmpty((String)elsTax.getId())) {
            elsTaxLambdaQueryWrapper.ne(BaseEntity::getId, (Object)elsTax.getId());
        }
        if (CollectionUtil.isNotEmpty((Collection)(elsTaxes = ((ElsTaxMapper)this.baseMapper).selectList((Wrapper)elsTaxLambdaQueryWrapper)))) {
            return true;
        }
        return false;
    }

    @Override
    public void updateElsTax(ElsTax elsTax) {
        Boolean isExist = this.checkTaxIsRepeat(elsTax);
        Assert.isTrue((isExist == false ? 1 : 0) != 0, (String)"\u5f53\u524d\u6dfb\u52a0\u7684\u7a0e\u7387-\u7a0e\u7801\u8bb0\u5f55\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728");
        ((ElsTaxMapper)this.baseMapper).updateById((Object)elsTax);
    }

    @Override
    public void delElsTax(String id) {
        ((ElsTaxMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTax(List<String> idList) {
        ((ElsTaxMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, Integer> getAllTax(String purchaseElsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)purchaseElsAccount);
        List taxList = this.list((Wrapper)queryWrapper);
        if (taxList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            taxList = this.list((Wrapper)queryWrapper);
        }
        return taxList.stream().filter(tax -> StrUtil.isNotBlank((CharSequence)tax.getTaxCode())).collect(Collectors.toMap(ElsTax::getTaxCode, ElsTax::getTaxRate));
    }

    @Override
    public List<ElsTax> findList(String elsAccount, String taxCode) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsTax::getTaxCode, (Object)taxCode)).list();
        return list;
    }

    @Override
    public List<ElsTax> getElsTaxByCode(String elsAccount, List<String> taxCode) {
        LambdaQueryWrapper sw = Wrappers.lambdaQuery();
        sw.select(new SFunction[]{ElsTax::getTaxCode, ElsTax::getTaxRate, ElsTax::getTaxName});
        ((LambdaQueryWrapper)sw.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(ElsTax::getTaxCode, taxCode);
        return ((ElsTaxMapper)this.baseMapper).selectList((Wrapper)sw);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getTaxRateData", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List elsTaxList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (ElsTax elsTax : elsTaxList) {
            this.pushDataToErp(elsTax);
        }
    }

    private void pushDataToErp(ElsTax elsTax) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushTaxRateData", (Object)elsTax);
    }
}

