/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.service.ConnectorConfigService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectorConfigImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    ConnectorConfigService connectorConfigService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<ConnectorConfig> connectorConfigList = new ArrayList<ConnectorConfig>();
        ArrayList<String> code = new ArrayList<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String systemCode = (String)data.get("systemCode");
            if (CharSequenceUtil.isEmpty((CharSequence)systemCode)) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"", (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"), data);
                iterator.remove();
                continue;
            }
            String systemVersion = (String)data.get("systemVersion");
            if (CharSequenceUtil.isEmpty((CharSequence)systemVersion)) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"", (String)"\u7cfb\u7edf\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"), data);
                iterator.remove();
                continue;
            }
            if (code.contains(systemCode + "," + systemCode)) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"", (String)"\u7cfb\u7edf\u7f16\u7801\u5bf9\u5e94\u7cfb\u7edf\u7248\u672c\u5df2\u5b58\u5728\u8bb0\u5f55"), data);
                iterator.remove();
                continue;
            }
            code.add(systemCode + "," + systemCode);
        }
        if (CollectionUtil.isEmpty(code)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.lambda().select(new SFunction[]{ConnectorConfig::getSystemCode, ConnectorConfig::getSystemVersion});
        wrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        wrapper.in((Object)"concat(system_code,',',system_version)", code);
        List dbCodeList = this.connectorConfigService.list((Wrapper)wrapper).stream().map(x -> x.getSystemCode() + "," + x.getSystemVersion()).distinct().collect(Collectors.toList());
        for (Map data : dataList) {
            ConnectorConfig entity = (ConnectorConfig)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), ConnectorConfig.class));
            if (dbCodeList.contains(entity.getSystemCode() + "," + entity.getSystemVersion())) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"", (String)"\u7cfb\u7edf\u7f16\u7801\u5bf9\u5e94\u7cfb\u7edf\u7248\u672c\u5df2\u5b58\u5728\u8bb0\u5f55"), data);
                continue;
            }
            entity.setElsAccount(TenantContext.getTenant());
            connectorConfigList.add(entity);
        }
        if (CollectionUtil.isNotEmpty(connectorConfigList)) {
            this.connectorConfigService.saveBatch(connectorConfigList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

