/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.excel.ConnectorConfigExportServiceImpl;
import com.els.modules.third.mapper.ConnectorConfigMapper;
import com.els.modules.third.service.ConnectorConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5e73\u53f0\u8fde\u63a5\u5668"})
@RestController
@RequestMapping(value={"/base/connectorConfig"})
public class ConnectorConfigController
extends BaseController<ConnectorConfig, ConnectorConfigService> {
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfigController.class);
    @Autowired
    private ConnectorConfigService connectorConfigService;
    @Autowired
    private ConnectorConfigMapper connectorConfigMapper;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ConnectorConfig connectorConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)connectorConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.connectorConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    public Result<?> queryPageSysList(ConnectorConfig connectorConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)connectorConfig), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.connectorConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ConnectorConfig connectorConfig) {
        this.connectorConfigService.add(connectorConfig);
        return Result.ok((Object)((Object)connectorConfig));
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ConnectorConfig connectorConfig) {
        this.connectorConfigService.edit(connectorConfig);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.connectorConfigService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.connectorConfigService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ConnectorConfig connectorConfig = (ConnectorConfig)((Object)this.connectorConfigService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)connectorConfig));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", notes="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(name="id") String id) {
        this.connectorConfigService.addToEnterprise(id);
        return Result.ok((Object)2);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, ConnectorConfigExportServiceImpl.class);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u5165")
    @PostMapping(value={"/jsonImport"})
    public Result<?> jsonImport(@RequestBody String json) throws Exception {
        String objName;
        int j;
        if (StrUtil.isBlank((CharSequence)json)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWLVWVWNWWWW_ab3548ad", (String)"json\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165json"));
        }
        try {
            JSONObject.parseObject((String)json);
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWyHNS_ca669dab", (String)"json\u89e3\u6790\u9519\u8bef"));
        }
        ArrayList<String> classFields = new ArrayList<String>();
        AccessibleObject[] objFields = Class.forName("com.els.modules.third.entity.ConnectorConfig").getDeclaredFields();
        AccessibleObject[] baseFields = Class.forName("com.els.modules.third.entity.ConnectorConfig").getSuperclass().getDeclaredFields();
        Field.setAccessible(objFields, true);
        Field.setAccessible(baseFields, true);
        if (objFields != null && objFields.length > 0) {
            for (j = 0; j < objFields.length; ++j) {
                objName = ((Field)objFields[j]).getName();
                classFields.add(objName);
            }
        }
        if (baseFields != null && baseFields.length > 0) {
            for (j = 0; j < baseFields.length; ++j) {
                objName = ((Field)baseFields[j]).getName();
                classFields.add(objName);
            }
        }
        ArrayList<ConnectorConfig> list = new ArrayList<ConnectorConfig>();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONArray jsonArray = jsonObject.getJSONArray("connectorConfig");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            Set fieldNames = object.keySet();
            for (String field : fieldNames) {
                if (classFields.contains(field)) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNKmWWWWWsMKNSJO_c3a0cbba", (String)"\u5bfc\u5165\u5931\u8d25\uff0cjson\u4e2d\u5b58\u5728\u9519\u8bef\u5b57\u6bb5"));
            }
            if (StrUtil.isNotBlank((CharSequence)object.getString("systemCode")) && StrUtil.isNotBlank((CharSequence)object.getString("systemVersion"))) {
                QueryWrapper QueryWrapper2 = new QueryWrapper();
                QueryWrapper2.eq((Object)"system_code", (Object)object.getString("systemCode"));
                QueryWrapper2.eq((Object)"system_version", (Object)object.getString("systemVersion"));
                QueryWrapper2.eq((Object)"els_account", (Object)"100000");
                ConnectorConfig connectorConfig = (ConnectorConfig)((Object)this.connectorConfigMapper.selectOne((Wrapper)QueryWrapper2));
                if (connectorConfig != null) {
                    log.error("\u5bfc\u5165\u5b58\u5728\u76f8\u540c\u7684\u7cfb\u7edf\u7f16\u7801{}\u548c\u7cfb\u7edf\u7248\u672c{}\u7684\u6570\u636e\uff0c\u5df2\u8df3\u8fc7", (Object)object.getString("systemCode"), (Object)object.getString("systemVersion"));
                    continue;
                }
            }
            ConnectorConfig connectorConfig = (ConnectorConfig)((Object)JSON.toJavaObject((JSON)object, ConnectorConfig.class));
            Date date = new Date();
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            connectorConfig.setElsAccount(sysUser.getElsAccount());
            if (connectorConfig.getCreateTime() == null) {
                connectorConfig.setCreateTime(date);
            }
            if (connectorConfig.getUpdateTime() == null) {
                connectorConfig.setCreateTime(date);
            }
            if (StrUtil.isBlank((CharSequence)connectorConfig.getCreateBy())) {
                connectorConfig.setCreateBy(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            }
            if (StrUtil.isBlank((CharSequence)connectorConfig.getUpdateBy())) {
                connectorConfig.setUpdateBy(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            }
            if (connectorConfig.getDeleted() == null) {
                connectorConfig.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            list.add(connectorConfig);
        }
        this.connectorConfigService.saveBatch(list);
        return Result.ok(list);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @PostMapping(value={"/jsonExport"})
    public Result<?> jsonExport(@RequestBody List<String> ids) {
        List list = this.connectorConfigMapper.selectBatchIds(ids);
        JSONArray jsonArray = new JSONArray();
        for (ConnectorConfig connectorConfig : list) {
            connectorConfig.setId(null);
            JSONObject jo = (JSONObject)JSONObject.toJSON((Object)((Object)connectorConfig));
            jsonArray.add((Object)jo);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("connectorConfig", (Object)jsonArray);
        return Result.ok((Object)jsonObject);
    }
}

