/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.entity.ConnectorFieldMapping;
import com.els.modules.third.entity.ConnectorInterface;
import com.els.modules.third.mapper.ConnectorConfigMapper;
import com.els.modules.third.mapper.ConnectorFieldMappingMapper;
import com.els.modules.third.mapper.ConnectorInterfaceMapper;
import com.els.modules.third.service.ConnectorFieldMappingService;
import com.els.modules.third.service.ConnectorInterfaceService;
import com.els.modules.third.vo.ConnectorInterfaceVO;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConnectorInterfaceServiceImpl
extends BaseServiceImpl<ConnectorInterfaceMapper, ConnectorInterface>
implements ConnectorInterfaceService {
    @Autowired
    private ConnectorConfigMapper connectorConfigMapper;
    @Autowired
    private ConnectorFieldMappingMapper connectorFieldMappingMapper;
    @Autowired
    private ConnectorInterfaceMapper connectorInterfaceMapper;
    @Autowired
    private ConnectorFieldMappingService connectorFieldMappingService;

    @Override
    @Transactional
    public void add(ConnectorInterface connectorInterface, List<ConnectorFieldMapping> connectorFieldMappingList) {
        ((ConnectorInterfaceMapper)this.baseMapper).insert((Object)connectorInterface);
        this.insertItemData(connectorInterface, connectorFieldMappingList);
    }

    @Override
    @Transactional
    public void edit(ConnectorInterface connectorInterface, List<ConnectorFieldMapping> connectorFieldMappingList) {
        ((ConnectorInterfaceMapper)this.baseMapper).updateById((Object)connectorInterface);
        this.connectorFieldMappingMapper.deleteByMainId(connectorInterface.getId());
        this.insertItemData(connectorInterface, connectorFieldMappingList);
    }

    @Override
    @Transactional
    public void delMain(String id) {
        ((ConnectorInterfaceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.connectorFieldMappingMapper.deleteByMainId(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> idList) {
        ((ConnectorInterfaceMapper)this.baseMapper).deleteBatchIds(idList);
        for (String id : idList) {
            this.connectorFieldMappingMapper.deleteByMainId(id);
        }
    }

    @Override
    public void addToEnterprise(String id) {
        ConnectorConfig config;
        ConnectorInterface anInterface = (ConnectorInterface)((Object)((ConnectorInterfaceMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ConnectorInterface::getSystemCode, (Object)anInterface.getSystemCode())).eq(ConnectorInterface::getSystemVersion, (Object)anInterface.getSystemVersion())).eq(ConnectorInterface::getSrmInterfaceCode, (Object)anInterface.getSrmInterfaceCode())).eq(ConnectorInterface::getInterfaceCode, (Object)anInterface.getInterfaceCode())).eq(ConnectorInterface::getImplementBean, (Object)anInterface.getImplementBean())).ne(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).last(" limit 1");
        Integer count = ((ConnectorInterfaceMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u8d26\u53f7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7cfb\u7edf\u7f16\u7801\u3001\u7cfb\u7edf\u7248\u672c\u3001SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u3001\u63a5\u53e3\u5e73\u53f0\u63a5\u53e3\u7f16\u7801\u3001\u5b9e\u73b0bean\u7684\u8fde\u63a5\u5668\u914d\u7f6e"));
        }
        ConnectorConfig clone = null;
        if (CharSequenceUtil.isNotEmpty((CharSequence)anInterface.getHeadId()) && null != (config = (ConnectorConfig)((Object)this.connectorConfigMapper.selectById((Serializable)((Object)anInterface.getHeadId()))))) {
            clone = (ConnectorConfig)((Object)ObjectUtil.clone((Object)((Object)config)));
            clone.setElsAccount(TenantContext.getTenant());
            clone.setId(IdWorker.getIdStr());
            clone.setCreateBy(null);
            clone.setCreateById(null);
            clone.setCreateBy(null);
            clone.setUpdateBy(null);
            clone.setUpdateById(null);
            clone.setUpdateTime(null);
            this.connectorConfigMapper.insert((Object)clone);
        }
        List<ConnectorFieldMapping> connectorFieldMappings = this.connectorFieldMappingMapper.selectByMainId(id);
        ConnectorInterface connectorInterface = new ConnectorInterface();
        BeanUtils.copyProperties((Object)((Object)anInterface), (Object)((Object)connectorInterface));
        connectorInterface.setId(IdWorker.getIdStr());
        connectorInterface.setElsAccount(TenantContext.getTenant());
        if (null != clone) {
            connectorInterface.setHeadId(clone.getId());
        }
        connectorInterface.setEnable("0");
        this.save((Object)connectorInterface);
        if (CollectionUtil.isNotEmpty(connectorFieldMappings)) {
            ArrayList<ConnectorFieldMapping> list = new ArrayList<ConnectorFieldMapping>();
            for (ConnectorFieldMapping connectorFieldMapping : connectorFieldMappings) {
                ConnectorFieldMapping companyFieldMapping = new ConnectorFieldMapping();
                BeanUtils.copyProperties((Object)((Object)connectorFieldMapping), (Object)((Object)companyFieldMapping));
                companyFieldMapping.setId(null);
                companyFieldMapping.setElsAccount(TenantContext.getTenant());
                companyFieldMapping.setCreateBy(null);
                companyFieldMapping.setCreateById(null);
                companyFieldMapping.setCreateBy(null);
                companyFieldMapping.setUpdateBy(null);
                companyFieldMapping.setUpdateById(null);
                companyFieldMapping.setUpdateTime(null);
                companyFieldMapping.setHeadId(connectorInterface.getId());
                list.add(companyFieldMapping);
            }
            this.connectorFieldMappingService.saveBatch(list);
        }
    }

    @Override
    public List<ConnectorInterface> selectByMainId(String id) {
        return ((ConnectorInterfaceMapper)this.baseMapper).selectByMainId(id);
    }

    private void insertItemData(ConnectorInterface connectorInterface, List<ConnectorFieldMapping> connectorFieldMappingList) {
        if (CollectionUtil.isNotEmpty(connectorFieldMappingList)) {
            for (ConnectorFieldMapping item : connectorFieldMappingList) {
                item.setHeadId(connectorInterface.getId());
                item.setSrmInterfaceCode(connectorInterface.getSrmInterfaceCode());
                item.setId(null);
                item.setInterfaceFieldGroupCode(CharSequenceUtil.emptyToDefault((CharSequence)item.getInterfaceFieldGroupCode(), (String)""));
                item.setMappingGroupCode(CharSequenceUtil.emptyToDefault((CharSequence)item.getMappingGroupCode(), (String)""));
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)connectorInterface);
            }
            connectorFieldMappingList.sort(Comparator.comparing(ConnectorFieldMapping::getMappingTable, Comparator.nullsFirst(String::compareTo)).thenComparing(ConnectorFieldMapping::getInterfaceField, Comparator.nullsFirst(String::compareTo)));
            ((ConnectorFieldMappingService)SpringContextUtils.getBean(ConnectorFieldMappingService.class)).saveBatch(connectorFieldMappingList);
        }
    }

    @Override
    public List<ConnectorInterfaceVO> jsonImport(String json) {
        if (StrUtil.isBlank((CharSequence)json)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWLVWVWNWWWW_ab3548ad", (String)"json\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165json"));
        }
        try {
            JSONObject.parseObject((String)json);
            JSONObject.parseObject((String)json).getJSONArray("connectorInterfaceVOList");
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWyHNS_ca669dab", (String)"json\u89e3\u6790\u9519\u8bef"));
        }
        ArrayList<String> classHeadFields = new ArrayList<String>();
        ArrayList<String> classItemFields = new ArrayList<String>();
        try {
            String objName;
            int j;
            AccessibleObject[] connectorInterfaceFields = Class.forName("com.els.modules.third.entity.ConnectorInterface").getDeclaredFields();
            AccessibleObject[] connectorFieldMappingobjFields = Class.forName("com.els.modules.third.entity.ConnectorFieldMapping").getDeclaredFields();
            AccessibleObject[] baseFields = Class.forName("com.els.modules.third.entity.ConnectorInterface").getSuperclass().getDeclaredFields();
            Field.setAccessible(connectorInterfaceFields, true);
            Field.setAccessible(connectorFieldMappingobjFields, true);
            Field.setAccessible(baseFields, true);
            if (connectorInterfaceFields != null && connectorInterfaceFields.length > 0) {
                for (j = 0; j < connectorInterfaceFields.length; ++j) {
                    objName = ((Field)connectorInterfaceFields[j]).getName();
                    classHeadFields.add(objName);
                }
            }
            if (connectorFieldMappingobjFields != null && connectorFieldMappingobjFields.length > 0) {
                for (j = 0; j < connectorFieldMappingobjFields.length; ++j) {
                    objName = ((Field)connectorFieldMappingobjFields[j]).getName();
                    classItemFields.add(objName);
                }
            }
            if (baseFields != null && baseFields.length > 0) {
                for (j = 0; j < baseFields.length; ++j) {
                    objName = ((Field)baseFields[j]).getName();
                    classHeadFields.add(objName);
                    classItemFields.add(objName);
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        ArrayList<ConnectorInterfaceVO> list = new ArrayList<ConnectorInterfaceVO>();
        ArrayList<ConnectorInterface> headList = new ArrayList<ConnectorInterface>();
        ArrayList<ConnectorFieldMapping> itemList = new ArrayList<ConnectorFieldMapping>();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONArray jsonArray = jsonObject.getJSONArray("connectorInterfaceVOList");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            Set fieldNames = object.keySet();
            for (String field : fieldNames) {
                if (classHeadFields.contains(field) || field.equals("connectorFieldMappingList")) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNKmWWWWWsMKNSJO_c3a0cbba", (String)"\u5bfc\u5165\u5931\u8d25\uff0cjson\u4e2d\u5b58\u5728\u9519\u8bef\u5b57\u6bb5"));
            }
            JSONArray connectorFieldMappingList = object.getJSONArray("connectorFieldMappingList");
            for (int j = 0; j < connectorFieldMappingList.size(); ++j) {
                JSONObject itemObject = connectorFieldMappingList.getJSONObject(i);
                Set itemFieldNames = itemObject.keySet();
                for (String field : itemFieldNames) {
                    if (classItemFields.contains(field)) continue;
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNKmWWWWWsMKNSJO_c3a0cbba", (String)"\u5bfc\u5165\u5931\u8d25\uff0cjson\u4e2d\u5b58\u5728\u9519\u8bef\u5b57\u6bb5"));
                }
            }
            if (StrUtil.isNotBlank((CharSequence)object.getString("srmInterfaceCode"))) {
                QueryWrapper QueryWrapper2 = new QueryWrapper();
                QueryWrapper2.eq((Object)"srm_interface_code", (Object)object.getString("srmInterfaceCode"));
                QueryWrapper2.eq((Object)"els_account", (Object)"100000");
                ConnectorInterface connectorInterface = (ConnectorInterface)((Object)this.connectorInterfaceMapper.selectOne((Wrapper)QueryWrapper2));
                if (connectorInterface != null) {
                    this.log.error("\u5bfc\u5165\u5b58\u5728\u76f8\u540c\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u7684\u6570\u636e\uff0c\u5df2\u8df3\u8fc7");
                    continue;
                }
            }
            if (StrUtil.isBlank((CharSequence)object.getString("systemCode")) || StrUtil.isBlank((CharSequence)object.getString("systemVersion"))) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b57\u6bb5\u7cfb\u7edf\u7f16\u7801\u548c\u7cfb\u7edf\u7248\u672c\u4e0d\u53ef\u7f3a\u5931"));
            }
            ConnectorConfig connectorConfig = this.connectorConfigMapper.queryBySystemCodeAndVersion(object.getString("systemCode"), object.getString("systemVersion"));
            if (connectorConfig == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrHeAonHervjKyA_2c41d57a", (String)"\u4e0d\u5b58\u5728\u8be5\u7cfb\u7edf\u7f16\u7801\u548c\u7cfb\u7edf\u7248\u672c\u7684\u8fde\u63a5\u5668"));
            }
            ConnectorInterfaceVO connectorInterfaceVO = (ConnectorInterfaceVO)((Object)JSON.toJavaObject((JSON)object, ConnectorInterfaceVO.class));
            Date date = new Date();
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List<ConnectorFieldMapping> connectorFieldMappingList1 = connectorInterfaceVO.getConnectorFieldMappingList();
            String id = IdWorker.getIdStr();
            for (ConnectorFieldMapping item : connectorFieldMappingList1) {
                item.setElsAccount(sysUser.getElsAccount());
                item.setHeadId(id);
                if (item.getCreateTime() == null) {
                    item.setCreateTime(date);
                }
                if (item.getUpdateTime() == null) {
                    item.setCreateTime(date);
                }
                if (StrUtil.isBlank((CharSequence)item.getCreateBy())) {
                    item.setCreateBy(sysUser.getSubAccount() + "_" + sysUser.getRealname());
                }
                if (StrUtil.isBlank((CharSequence)item.getUpdateBy())) {
                    item.setUpdateBy(sysUser.getSubAccount() + "_" + sysUser.getRealname());
                }
                if (item.getDeleted() == null) {
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                }
                itemList.add(item);
            }
            connectorInterfaceVO.setElsAccount(sysUser.getElsAccount());
            connectorInterfaceVO.setId(id);
            if (connectorInterfaceVO.getCreateTime() == null) {
                connectorInterfaceVO.setCreateTime(date);
            }
            if (connectorInterfaceVO.getUpdateTime() == null) {
                connectorInterfaceVO.setCreateTime(date);
            }
            if (StrUtil.isBlank((CharSequence)connectorInterfaceVO.getCreateBy())) {
                connectorInterfaceVO.setCreateBy(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            }
            if (StrUtil.isBlank((CharSequence)connectorInterfaceVO.getUpdateBy())) {
                connectorInterfaceVO.setUpdateBy(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            }
            if (connectorInterfaceVO.getDeleted() == null) {
                connectorInterfaceVO.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            if (StrUtil.isBlank((CharSequence)connectorInterfaceVO.getHeadId())) {
                connectorInterfaceVO.setHeadId(connectorConfig.getId());
            }
            if (StrUtil.isBlank((CharSequence)connectorInterfaceVO.getEnable())) {
                connectorInterfaceVO.setEnable("0");
            }
            if (connectorInterfaceVO.getDeleted() == null) {
                connectorInterfaceVO.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            ConnectorInterface connectorInterface = new ConnectorInterface();
            BeanUtils.copyProperties((Object)((Object)connectorInterfaceVO), (Object)((Object)connectorInterface));
            headList.add(connectorInterface);
            list.add(connectorInterfaceVO);
        }
        this.saveBatch(headList);
        this.connectorFieldMappingService.saveBatch(itemList);
        return list;
    }
}

