/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.base.api.enumerate.ConnectorMappingTypeEnum;
import com.els.modules.third.vo.JSONConversionVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class JSONParsingUtil {
    public static List<JSONConversionVO> parsing(String json) {
        List<JSONConversionVO> conversions = new ArrayList<JSONConversionVO>();
        JSONParsingUtil.conversion("", JSONObject.parseObject((String)json), conversions, ConnectorMappingTypeEnum.HEAD.getValue());
        conversions = conversions.stream().sorted(Comparator.comparingInt(x -> CharSequenceUtil.split((CharSequence)x.getInterfaceFieldGroupCode(), (CharSequence)".").size())).sorted(Comparator.comparingInt(x -> x.getInterfaceFieldGroupCode().length())).collect(Collectors.toList());
        return conversions;
    }

    private static void conversion(String groupCode, JSONObject object, List<JSONConversionVO> conversions, String mappingTable) {
        for (String fieldName : object.keySet()) {
            String loopGroupCode;
            Object o = object.get((Object)fieldName);
            if (o instanceof JSONObject) {
                String string = loopGroupCode = CharSequenceUtil.isEmpty((CharSequence)groupCode) ? fieldName + "." : groupCode + fieldName + ".";
                if (ConnectorMappingTypeEnum.ITEM.getValue().equals(mappingTable)) {
                    JSONParsingUtil.conversion(loopGroupCode, (JSONObject)o, conversions, ConnectorMappingTypeEnum.ITEM_OBJ_ITEM_OBJ.getValue());
                    continue;
                }
                JSONParsingUtil.conversion(loopGroupCode, (JSONObject)o, conversions, ConnectorMappingTypeEnum.OBJ.getValue());
                continue;
            }
            if (o instanceof JSONArray) {
                String string = loopGroupCode = CharSequenceUtil.isEmpty((CharSequence)groupCode) ? fieldName + "." : groupCode + fieldName + ".";
                JSONArray list = (JSONArray)o;
                if (list.isEmpty()) continue;
                List objectList = list.toJavaList(JSONObject.class);
                JSONObject jsonObject = (JSONObject)objectList.stream().sorted(Comparator.comparingInt(x -> x.keySet().size())).collect(Collectors.toList()).get(list.size() - 1);
                JSONParsingUtil.conversion(loopGroupCode, jsonObject, conversions, ConnectorMappingTypeEnum.ITEM.getValue());
                continue;
            }
            String temGroupCode = groupCode;
            if (groupCode.endsWith(".")) {
                temGroupCode = groupCode.substring(0, groupCode.length() - 1);
            }
            JSONConversionVO vo = new JSONConversionVO();
            vo.setInterfaceField(fieldName);
            vo.setInterfaceFieldGroupCode(temGroupCode);
            vo.setFieldType("string");
            vo.setMappingField(fieldName);
            vo.setMappingTable(mappingTable);
            vo.setMappingGroupCode(temGroupCode);
            conversions.add(vo);
        }
    }
}

