/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.excel.service.BaseExportService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.mapper.I18nMapper;
import com.els.modules.language.vo.I18nVO;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="i18nExportServiceImpl")
public class I18nExportServiceImpl
extends BaseExportService<I18n, I18nVO, I18nVO>
implements ExportDataLoaderService {
    @Autowired
    private I18nMapper i18nMapper;

    @PermissionDataView(businessType="contract")
    public List<I18nVO> queryExportData(QueryWrapper<I18n> queryWrapper, I18nVO param, Map<String, String[]> paramMap) {
        param.setElsAccount(TenantContext.getTenant());
        return this.i18nMapper.findListAll(param);
    }

    public long queryExportDataCount(QueryWrapper<I18n> queryWrapper, I18nVO map, Map<String, String[]> paramMap) {
        map.setElsAccount(TenantContext.getTenant());
        return this.i18nMapper.findListAllCount(map);
    }

    public String getBusinessType() {
        return "I18n";
    }

    public String getBeanName() {
        return "i18nExportExcelDataBatchQueryLoader";
    }

    protected boolean doQueryWrapperFiler() {
        return false;
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        I18nVO i18nVO = (I18nVO)JSONObject.parseObject((String)JSON.toJSONString(entityMap), I18nVO.class);
        i18nVO.setElsAccount(TenantContext.getTenant());
        return JSON.toJSONString((Object)this.i18nMapper.findPageAll(i18nVO, (Page<I18nVO>)page).getRecords());
    }
}

