/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.translate.util;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.config.TencentTmtConfig;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.tmt.v20180321.TmtClient;
import com.tencentcloudapi.tmt.v20180321.models.TextTranslateBatchRequest;
import com.tencentcloudapi.tmt.v20180321.models.TextTranslateBatchResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentTmtClientUtils {
    private static final Logger log = LoggerFactory.getLogger(TencentTmtClientUtils.class);
    private static TencentTmtConfig tencentTmtConfig = (TencentTmtConfig)SpringUtil.getBean(TencentTmtConfig.class);

    private TencentTmtClientUtils() {
    }

    public static Map<String, String> TencentTmtTx(List<String> sourceStr, String from, String to) {
        if (!TencentTmtClientUtils.tencentTmtCheck()) {
            throw new RuntimeException("\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\u6b63\u786e\u7684\u817e\u8baf\u7ffb\u8bd1\u8d26\u53f7\u4fe1\u606f");
        }
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        try {
            Object object;
            Credential cred = new Credential(tencentTmtConfig.getSecretId(), tencentTmtConfig.getSecretKey());
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint(tencentTmtConfig.getEndpoint());
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            TmtClient tmtClient = new TmtClient(cred, tencentTmtConfig.getRegion(), clientProfile);
            TextTranslateBatchRequest req = new TextTranslateBatchRequest();
            req.setSource(from);
            req.setTarget(to);
            req.setProjectId(Long.valueOf(0L));
            String[] sourceTextList1 = sourceStr.toArray(new String[sourceStr.size()]);
            req.setSourceTextList(sourceTextList1);
            TextTranslateBatchResponse resp = tmtClient.TextTranslateBatch(req);
            String s = TextTranslateBatchResponse.toJsonString((AbstractModel)resp);
            JSONObject jsonObject = JSON.parseObject((String)s);
            if (jsonObject.containsKey((Object)"TargetTextList") && (object = JSON.parse((String)jsonObject.getString("TargetTextList"))) instanceof JSONArray) {
                JSONArray array = (JSONArray)object;
                if (sourceStr.size() == array.size()) {
                    for (int i = 0; i < sourceStr.size(); ++i) {
                        stringStringHashMap.put(sourceStr.get(i), array.getString(i));
                    }
                }
            }
        }
        catch (TencentCloudSDKException e) {
            throw new RuntimeException(e);
        }
        return stringStringHashMap;
    }

    private static boolean tencentTmtCheck() {
        if (tencentTmtConfig == null) {
            tencentTmtConfig = (TencentTmtConfig)SpringUtil.getBean(TencentTmtConfig.class);
        }
        return !StringUtils.isBlank((String)tencentTmtConfig.getEndpoint()) && !StringUtils.isBlank((String)tencentTmtConfig.getSecretId()) && !StringUtils.isBlank((String)tencentTmtConfig.getSecretKey()) && !StringUtils.isBlank((String)tencentTmtConfig.getRegion());
    }
}

