/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.system.entity.District;
import com.els.modules.system.model.DistrictModel;
import com.els.modules.system.service.DistrictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u884c\u653f\u533a\u57df"})
@RestController
@RequestMapping(value={"/base/district"})
@Deprecated
public class DistrictController
extends BaseController<District, DistrictService> {
    @Autowired
    private DistrictService districtService;

    @ApiOperation(value="\u884c\u653f\u533a\u57df-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u884c\u653f\u533a\u57df-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system#district:list"})
    public Result<?> queryPageList(District district, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)district, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.districtService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u884c\u653f\u533a\u57df-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u884c\u653f\u533a\u57df-\u6dfb\u52a0", notes="\u884c\u653f\u533a\u57df-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"system#district:add"})
    public Result<?> add(@RequestBody District district) {
        this.districtService.saveDistrict(district);
        return this.commonSuccessResult(2);
    }

    @SrmValidated
    @AutoLog(value="\u884c\u653f\u533a\u57df-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="\u884c\u653f\u533a\u57df-\u7f16\u8f91", notes="\u884c\u653f\u533a\u57df-\u7f16\u8f91")
    @PutMapping(value={"/edit"})
    @RequiresPermissions(value={"system#district:edit"})
    public Result<?> edit(@RequestBody District district) {
        this.districtService.updateDistrict(district);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u884c\u653f\u533a\u57df-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @ApiOperation(value="\u884c\u653f\u533a\u57df-\u901a\u8fc7id\u5220\u9664", notes="\u884c\u653f\u533a\u57df-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    @RequiresPermissions(value={"system#district:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.districtService.delDistrict(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u884c\u653f\u533a\u57df-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u884c\u653f\u533a\u57df-\u6279\u91cf\u5220\u9664", notes="\u884c\u653f\u533a\u57df-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"system#district:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.districtService.delBatchDistrict(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u884c\u653f\u533a\u57df-\u901a\u8fc7id\u67e5\u8be2", notes="\u884c\u653f\u533a\u57df-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"system#district:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        District district = (District)this.districtService.getById((Serializable)((Object)id));
        return Result.ok((Object)district);
    }

    @AutoLog(value="\u884c\u653f\u533a\u57df-\u67e5\u8be2\u7701\u5e02\u533a\u53bf\u6811\u5f62\u7ed3\u6784", operateType=1)
    @RequestMapping(value={"/districtTree"}, method={RequestMethod.GET})
    @ApiOperation(value="\u884c\u653f\u533a\u57df-\u7701\u5e02\u533a\u53bf\u6811\u5f62\u7ed3\u6784", notes="\u884c\u653f\u533a\u57df-\u7701\u5e02\u533a\u53bf\u6811\u5f62\u7ed3\u6784")
    @RequiresPermissions(value={"system#district:queryById"})
    public Result<?> districtTree(@RequestParam(name="countryCode") String countryCode) {
        List<DistrictModel> resultList = this.districtService.districtTree(countryCode);
        return Result.ok(resultList);
    }
}

