/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.els.common.exception.ELSBootException;
import com.els.common.util.GenerateSignatureUtil;
import com.els.common.util.I18nUtil;
import com.els.config.DecryptTenderProperties;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.enumerate.FileStorageTypeEnum;
import com.els.modules.attachment.storage.spi.AbstractStorageSpi;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="decryptStorageSpi")
public class DecryptStorageClient
extends AbstractStorageSpi {
    private static final Logger log = LoggerFactory.getLogger(DecryptStorageClient.class);
    private static final String SUCCESS = "0";
    private static final String SUCCESS_CODE = "code";
    private static final String SUCCESS_DATA = "data";
    private static final String APP_ID = "appId";
    private static final String SIGNATURE = "signature";
    @Autowired
    private DecryptTenderProperties decryptTenderProperties;

    public OSSClient loadStorageClient() {
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APQIMGCKxTPqDO_d3760f73", (String)"\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u6a21\u5f0f\u4e0d\u9700\u8981\u5ba2\u6237\u7aef"));
    }

    @Override
    public String type() {
        return FileStorageTypeEnum.DECRYPT.getCode();
    }

    @Override
    public String loadDownloadSafePath(StorageFileInfo fileInfo) {
        Map<String, Object> params;
        RestTemplate restTemplate = new RestTemplate();
        String url = this.getBaseUrl() + "/tender/certification/getSignature?appId={appId}&signature={signature}&filePath={filePath}";
        ResponseEntity responseEntity = restTemplate.getForEntity(url, String.class, params = this.getParams(fileInfo.getPath()));
        String body = (String)responseEntity.getBody();
        JSONObject jsonObject = JSON.parseObject((String)body);
        if (SUCCESS.equals(jsonObject.get((Object)SUCCESS_CODE).toString())) {
            return jsonObject.getString(SUCCESS_DATA);
        }
        log.error("load_downloadSafePath_error:{}", (Object)body);
        throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u52a0\u8f7d\u5b89\u5168\u94fe\u63a5\u5931\u8d25"));
    }

    private Map<String, Object> getParams(String filePath) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(APP_ID, this.decryptTenderProperties.getAppId());
        String signature = GenerateSignatureUtil.getSignature((String)this.decryptTenderProperties.getAppKey(), (String)this.decryptTenderProperties.getAppId(), (String)this.decryptTenderProperties.getSecret());
        try {
            params.put(SIGNATURE, URLEncoder.encode(signature, "utf-8"));
            params.put("filePath", URLEncoder.encode(filePath, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
        }
        return params;
    }

    @Override
    public String loadDownloadPath(String objectPath) {
        StorageFileInfo fileInfo = new StorageFileInfo();
        fileInfo.setPath(objectPath);
        return this.loadDownloadSafePath(fileInfo);
    }

    @Override
    public boolean store(final StorageFileInfo fileInfo) {
        try {
            String url = this.getBaseUrl() + "/tender/certification/encryption/upload";
            RestTemplate template = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "multipart/form-data");
            headers.add("Content-Length", String.valueOf(fileInfo.getSize()));
            headers.add(APP_ID, this.decryptTenderProperties.getAppId());
            String signature = GenerateSignatureUtil.getSignature((String)this.decryptTenderProperties.getAppKey(), (String)this.decryptTenderProperties.getAppId(), (String)this.decryptTenderProperties.getSecret());
            headers.add(SIGNATURE, signature);
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            ByteArrayResource resource = new ByteArrayResource(DecryptStorageClient.toByteArray(fileInfo.getInputStream())){

                public String getFilename() {
                    return fileInfo.getOriginalFilename();
                }
            };
            parts.add((Object)"file", (Object)resource);
            parts.add((Object)"caType", (Object)fileInfo.getCaType());
            HttpEntity httpEntity = new HttpEntity((Object)parts, (MultiValueMap)headers);
            ResponseEntity responseEntity = template.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            String body = (String)responseEntity.getBody();
            JSONObject jsonObject = JSON.parseObject((String)body);
            if (SUCCESS.equals(jsonObject.get((Object)SUCCESS_CODE).toString())) {
                String data = jsonObject.getString(SUCCESS_DATA);
                JSONArray jsonArray = JSON.parseArray((String)data);
                JSONObject result = JSON.parseObject((String)JSON.toJSONString((Object)jsonArray.get(0)));
                fileInfo.setId(result.getString("id"));
                fileInfo.setPath(result.getString("path"));
                return true;
            }
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:{}", (Object)body);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return false;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    @Override
    public String getBaseUrl() {
        return this.decryptTenderProperties.getUrl();
    }

    @Override
    public boolean delete(String filePath) {
        return false;
    }

    @Override
    public boolean deleteFileBatch(List<String> remotePaths) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFileWithOutput(HttpServletResponse response, OutputStream outputStream, String filePath) {
        try {
            String url = this.getBaseUrl() + "/tender/certification/download?appId={appId}&signature={signature}&filePath={filePath}";
            Map<String, Object> params = this.getParams(filePath);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity responseEntity = restTemplate.getForEntity(url, byte[].class, params);
            byte[] bytes = (byte[])responseEntity.getBody();
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }
}

