/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.entity.ConnectorInterface;
import com.els.modules.third.service.ConnectorConfigService;
import com.els.modules.third.service.ConnectorInterfaceService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectorInterfaceImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private ConnectorConfigService connectorConfigService;
    @Autowired
    private ConnectorInterfaceService connectorInterfaceService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<ConnectorInterface> connectorInterfaceList = new ArrayList<ConnectorInterface>();
        ArrayList<String> interfaceCodeList = new ArrayList<String>();
        ArrayList<String> code = new ArrayList<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String srmInterfaceCode = (String)data.get("srmInterfaceCode");
            if (CharSequenceUtil.isEmpty((CharSequence)srmInterfaceCode)) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"i18n_alert_WWWCxyVAoxOLV_cae96dea", (String)"SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"), data);
                iterator.remove();
                continue;
            }
            if (interfaceCodeList.contains(srmInterfaceCode)) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"i18n_alert_WWWCxyVAoIMK_a3aa0328", (String)"SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u5df2\u5b58\u5728"), data);
                iterator.remove();
                continue;
            }
            interfaceCodeList.add(srmInterfaceCode);
            String systemCode = (String)data.get("systemCode");
            if (CharSequenceUtil.isEmpty((CharSequence)systemCode)) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"i18n_alert_HeAoxOLV_eeb7b07f", (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"), data);
                iterator.remove();
                continue;
            }
            String systemVersion = (String)data.get("systemVersion");
            if (CharSequenceUtil.isEmpty((CharSequence)systemVersion)) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"i18n_alert_HervxOLV_27d84e38", (String)"\u7cfb\u7edf\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"), data);
                iterator.remove();
                continue;
            }
            if (code.contains(systemCode + "," + systemVersion)) continue;
            code.add(systemCode + "," + systemVersion);
        }
        if (CollectionUtil.isEmpty(interfaceCodeList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{ConnectorInterface::getSrmInterfaceCode}).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(ConnectorInterface::getInterfaceCode, interfaceCodeList);
        List dbCodeList = this.connectorInterfaceService.list((Wrapper)wrapper).stream().map(ConnectorInterface::getInterfaceCode).distinct().collect(Collectors.toList());
        QueryWrapper wrapper1 = Wrappers.query();
        wrapper1.lambda().select(new SFunction[]{ConnectorConfig::getSystemCode, ConnectorConfig::getSystemVersion, BaseEntity::getId});
        wrapper1.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        wrapper1.in((Object)"concat(system_code,',',system_version)", code);
        Map dbCodeMap = this.connectorConfigService.list((Wrapper)wrapper1).stream().collect(Collectors.toMap(x -> x.getSystemCode() + "," + x.getSystemVersion(), Function.identity(), (v1, v2) -> v2));
        for (Map data : dataList) {
            ConnectorInterface entity = (ConnectorInterface)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), ConnectorInterface.class));
            if (dbCodeList.contains(entity.getInterfaceCode())) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"i18n_alert_WWWCxyVAoIMK_a3aa0328", (String)"SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u5df2\u5b58\u5728"), data);
                continue;
            }
            if (!dbCodeMap.containsKey(entity.getSystemCode() + "," + entity.getSystemVersion())) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"i18n_alert_xMKHeAoWWWWnHervWWWWjKyA_41777304", (String)"\u4e0d\u5b58\u5728\u7cfb\u7edf\u7f16\u7801${0}\u548c\u7cfb\u7edf\u7248\u672c${1}\u7684\u8fde\u63a5\u5668", (String[])new String[]{entity.getSystemCode(), entity.getSystemVersion()}), data);
                continue;
            }
            ConnectorConfig config = (ConnectorConfig)((Object)dbCodeMap.get(entity.getSystemCode() + "," + entity.getSystemVersion()));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setHeadId(config.getId());
            if (CharSequenceUtil.isBlank((CharSequence)entity.getEnable())) {
                entity.setEnable("0");
            }
            connectorInterfaceList.add(entity);
        }
        if (CollectionUtil.isNotEmpty(connectorInterfaceList)) {
            this.connectorInterfaceService.saveBatch(connectorInterfaceList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

