/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.listener;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.integrated.entity.IntegratedBusinessData;
import com.els.modules.integrated.entity.IntegratedBusinessDataLinks;
import com.els.modules.integrated.service.IntegratedBusinessDataLinksService;
import com.els.modules.integrated.service.IntegratedBusinessDataService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntegratedDataConsumer {
    private static final Logger log = LoggerFactory.getLogger(IntegratedDataConsumer.class);
    @Autowired
    private IntegratedBusinessDataService integratedBusinessDataService;
    @Autowired
    private IntegratedBusinessDataLinksService integratedBusinessDataLinksService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(String msgBody) {
        if (StringUtils.isBlank((CharSequence)msgBody)) {
            return;
        }
        JSONObject body = JSONObject.parseObject((String)msgBody);
        log.info("\u63a5\u6536\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + body.toJSONString());
        try {
            if (body.containsKey((Object)"dataType") && "integrateData".equals(body.getString("dataType")) && body.containsKey((Object)"data")) {
                JSONObject integrateData = body.getJSONObject("data");
                IntegratedBusinessData integratedBusinessData = (IntegratedBusinessData)((Object)JSONObject.parseObject((String)body.getString("data"), IntegratedBusinessData.class));
                integratedBusinessData.setDataJson(integrateData.getJSONObject("jsonData").toJSONString());
                this.integratedBusinessDataService.updateIntegratedData(integratedBusinessData);
            }
            if (body.containsKey((Object)"dataType") && "integrateDataLink".equals(body.getString("dataType"))) {
                if (body.containsKey((Object)"delItemStringList")) {
                    List delItemStringList = JSONArray.parseArray((String)body.getString("delItemStringList"), String.class);
                    this.integratedBusinessDataLinksService.deleteByBusinessIdList(delItemStringList, "item");
                }
                if (body.containsKey((Object)"delHeadStringList")) {
                    List delHeadStringList = JSONArray.parseArray((String)body.getString("delHeadStringList"), String.class);
                    this.integratedBusinessDataLinksService.deleteByBusinessIdList(delHeadStringList, "head");
                }
                if (body.containsKey((Object)"jsonArray")) {
                    JSONArray jsonArray = body.getJSONArray("jsonArray");
                    List integratedBusinessDataLinks = jsonArray.toJavaList(IntegratedBusinessDataLinks.class);
                    for (IntegratedBusinessDataLinks link : integratedBusinessDataLinks) {
                        this.integratedBusinessDataLinksService.saveIntegratedBusinessDataLinks(link.getElsAccount(), link.getBusinessType(), link.getBusinessDataType(), link.getIntegratedId(), link.getBusinessParentId(), link.getBusinessId());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("save log failed:", (Throwable)e);
        }
    }
}

