/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.mapper.ConnectorConfigMapper;
import com.els.modules.third.service.ConnectorConfigService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConnectorConfigServiceImpl
extends BaseServiceImpl<ConnectorConfigMapper, ConnectorConfig>
implements ConnectorConfigService {
    @Override
    public void add(ConnectorConfig connectorConfig) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ConnectorConfig::getSystemCode, (Object)connectorConfig.getSystemCode())).eq(ConnectorConfig::getSystemVersion, (Object)connectorConfig.getSystemVersion())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        int count = this.count((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyIIMKdeHeAonrvjKyA_8579cec8", (String)"\u5f53\u524d\u8d26\u53f7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7cfb\u7edf\u7f16\u7801\u548c\u7248\u672c\u7684\u8fde\u63a5\u5668"));
        }
        ((ConnectorConfigMapper)this.baseMapper).insert((Object)connectorConfig);
    }

    @Override
    public void edit(ConnectorConfig connectorConfig) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ConnectorConfig::getSystemCode, (Object)connectorConfig.getSystemCode())).eq(ConnectorConfig::getSystemVersion, (Object)connectorConfig.getSystemVersion())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).ne(BaseEntity::getId, (Object)connectorConfig.getId());
        int count1 = this.count((Wrapper)wrapper);
        if (count1 > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyIIMKdeHeAonrvjKyA_8579cec8", (String)"\u5f53\u524d\u8d26\u53f7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7cfb\u7edf\u7f16\u7801\u548c\u7248\u672c\u7684\u8fde\u63a5\u5668"));
        }
        int count = ((ConnectorConfigMapper)this.baseMapper).updateById((Object)connectorConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ConnectorConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ConnectorConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void addToEnterprise(String id) {
        ConnectorConfig config = (ConnectorConfig)((Object)this.getById((Serializable)((Object)id)));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ConnectorConfig::getSystemCode, (Object)config.getSystemCode())).eq(ConnectorConfig::getSystemVersion, (Object)config.getSystemVersion())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).last(" limit 1");
        Integer count = ((ConnectorConfigMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyIIMKdeHeAonrvjKyA_8579cec8", (String)"\u5f53\u524d\u8d26\u53f7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7cfb\u7edf\u7f16\u7801\u548c\u7248\u672c\u7684\u8fde\u63a5\u5668"));
        }
        ConnectorConfig clone = (ConnectorConfig)((Object)ObjectUtil.clone((Object)((Object)config)));
        clone.setElsAccount(TenantContext.getTenant());
        clone.setId(null);
        clone.setCreateBy(null);
        clone.setCreateById(null);
        clone.setCreateBy(null);
        clone.setUpdateBy(null);
        clone.setUpdateById(null);
        clone.setUpdateTime(null);
        ((ConnectorConfigMapper)this.baseMapper).insert((Object)clone);
    }

    @Override
    public ConnectorConfig loadConnectorConfig(String elsAccount, String systemCode, String systemVersion) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ConnectorConfig::getSystemCode, (Object)systemCode)).eq(ConnectorConfig::getSystemVersion, (Object)systemVersion)).last(" limit 1");
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        return (ConnectorConfig)((Object)this.getOne((Wrapper)wrapper));
    }

    @Override
    public void jsonImport(String json) {
        if (CharSequenceUtil.isBlank((CharSequence)json)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VuNWWWWWF_f5f40606", (String)"\u8bf7\u5bfc\u5165json\u6570\u636e"));
        }
        ConnectorConfig objData = null;
        List<ConnectorConfig> listObjData = Lists.newArrayList();
        try {
            objData = (ConnectorConfig)((Object)JSON.parseObject((String)json, ConnectorConfig.class));
        }
        catch (Exception e) {
            try {
                listObjData = JSON.parseArray((String)json, ConnectorConfig.class);
            }
            catch (Exception ee) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWyHNS_ca669dab", (String)"json\u89e3\u6790\u9519\u8bef"));
            }
        }
        if (null == objData && CollectionUtil.isEmpty((Collection)listObjData)) {
            return;
        }
        if (null != objData) {
            listObjData.add(objData);
        }
        ArrayList<String> code = new ArrayList<String>();
        for (int index = 0; index < listObjData.size(); ++index) {
            ConnectorConfig vo = (ConnectorConfig)((Object)listObjData.get(index));
            if (CharSequenceUtil.isEmpty((CharSequence)vo.getSystemCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWHeAoxOLV_4f5ce16b", (String)"\u5bf9\u8c61${0}\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{index + ""}));
            }
            if (CharSequenceUtil.isEmpty((CharSequence)vo.getSystemVersion())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWHervxOLV_887d7f24", (String)"\u5bf9\u8c61${0}\u7cfb\u7edf\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{index + ""}));
            }
            if (code.contains(vo.getSystemCode() + "," + vo.getSystemVersion())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWHeAoIdHervIMKtH_91a40329", (String)"\u5bf9\u8c61${0}\u7cfb\u7edf\u7f16\u7801\u5bf9\u5e94\u7cfb\u7edf\u7248\u672c\u5df2\u5b58\u5728\u8bb0\u5f55", (String[])new String[]{index + ""}));
            }
            code.add(vo.getSystemCode() + "," + vo.getSystemVersion());
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.lambda().select(new SFunction[]{ConnectorConfig::getSystemCode, ConnectorConfig::getSystemVersion});
        wrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        wrapper.in((Object)"concat(system_code,',',system_version)", code);
        List dbCodeList = this.list((Wrapper)wrapper).stream().map(x -> x.getSystemCode() + "," + x.getSystemVersion()).distinct().collect(Collectors.toList());
        for (int index = 0; index < listObjData.size(); ++index) {
            ConnectorConfig entity = (ConnectorConfig)((Object)listObjData.get(index));
            if (dbCodeList.contains(entity.getSystemCode() + "," + entity.getSystemVersion())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWHeAoIdHervIMKtH_91a40329", (String)"\u5bf9\u8c61${0}\u7cfb\u7edf\u7f16\u7801\u5bf9\u5e94\u7cfb\u7edf\u7248\u672c\u5df2\u5b58\u5728\u8bb0\u5f55", (String[])new String[]{index + ""}));
            }
            entity.setElsAccount(TenantContext.getTenant());
            entity.setId(null);
        }
        if (CollectionUtil.isNotEmpty(listObjData)) {
            this.saveBatch(listObjData);
        }
    }
}

